/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.withid.folder;

import com.phloc.commons.combine.ICombinator;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.withid.BasicTreeItemWithID;
import com.phloc.commons.tree.withid.folder.IFolderTreeItem;
import com.phloc.commons.tree.withid.folder.IFolderTreeItemFactory;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicFolderTreeItem<KEYTYPE, VALUETYPE, COLLTYPE extends Collection<VALUETYPE>, ITEMTYPE extends BasicFolderTreeItem<KEYTYPE, VALUETYPE, COLLTYPE, ITEMTYPE>>
extends BasicTreeItemWithID<KEYTYPE, COLLTYPE, ITEMTYPE>
implements IFolderTreeItem<KEYTYPE, VALUETYPE, COLLTYPE, ITEMTYPE> {
    private final ICombinator<KEYTYPE> m_aKeyCombinator;

    public BasicFolderTreeItem(@Nonnull IFolderTreeItemFactory<KEYTYPE, VALUETYPE, COLLTYPE, ITEMTYPE> aFactory) {
        super(aFactory);
        this.m_aKeyCombinator = aFactory.getKeyCombinator();
    }

    public BasicFolderTreeItem(@Nonnull IFolderTreeItemFactory<KEYTYPE, VALUETYPE, COLLTYPE, ITEMTYPE> aFactory, @Nullable KEYTYPE aDataID) {
        super(aFactory, aDataID);
        this.m_aKeyCombinator = aFactory.getKeyCombinator();
    }

    public BasicFolderTreeItem(@Nonnull ITEMTYPE aParent, @Nonnull KEYTYPE aDataID) {
        super(aParent, aDataID);
        this.m_aKeyCombinator = ((BasicFolderTreeItem)aParent).m_aKeyCombinator;
    }

    @Override
    @Nonnull
    public final KEYTYPE getGlobalUniqueDataID() {
        if (this.m_aKeyCombinator == null) {
            return this.getID();
        }
        BasicFolderTreeItem aParent = (BasicFolderTreeItem)this.getParent();
        return aParent == null ? this.getID() : this.m_aKeyCombinator.combine(aParent.getGlobalUniqueDataID(), this.getID());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasicFolderTreeItem rhs = (BasicFolderTreeItem)o;
        return EqualsUtils.equals(this.m_aKeyCombinator, rhs.m_aKeyCombinator);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aKeyCombinator).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("keyCombinator", this.m_aKeyCombinator).toString();
    }
}

