/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.version;

import com.phloc.commons.IHasStringRepresentation;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.version.Version;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class VersionRange
implements Comparable<VersionRange>,
IHasStringRepresentation,
Serializable {
    public static final String DEFAULT_VERSION_RANGE_STRING = "[0)";
    private final boolean m_bIncludeFloor;
    private final Version m_aFloorVersion;
    private final boolean m_bIncludeCeil;
    private final Version m_aCeilVersion;

    public VersionRange(@Nullable String sVersionString) {
        String s;
        String string = s = sVersionString == null ? "" : sVersionString.trim();
        if (s.length() == 0) {
            this.m_bIncludeFloor = true;
            this.m_aFloorVersion = new Version("0");
            this.m_bIncludeCeil = false;
            this.m_aCeilVersion = null;
        } else {
            int i = 0;
            if (s.charAt(i) == '[') {
                this.m_bIncludeFloor = true;
                ++i;
            } else if (s.charAt(i) == '(') {
                this.m_bIncludeFloor = false;
                ++i;
            } else {
                this.m_bIncludeFloor = true;
            }
            int j = 0;
            if (StringHelper.endsWith((CharSequence)s, ']')) {
                this.m_bIncludeCeil = true;
                ++j;
            } else if (StringHelper.endsWith((CharSequence)s, ')')) {
                this.m_bIncludeCeil = false;
                ++j;
            } else {
                this.m_bIncludeCeil = false;
            }
            int nRestLen = s.length() - i - j;
            if (nRestLen == 0) {
                this.m_aFloorVersion = new Version("0");
                this.m_aCeilVersion = null;
            } else {
                String[] parts = StringHelper.getExplodedArray(',', s.substring(i, s.length() - j));
                String sFloor = parts[0].trim();
                String sCeiling = parts.length > 1 ? parts[1].trim() : null;
                this.m_aFloorVersion = new Version(sFloor);
                this.m_aCeilVersion = StringHelper.hasNoText(sCeiling) ? null : new Version(sCeiling);
            }
        }
        if (this.m_aCeilVersion != null && this.m_aFloorVersion.compareTo(this.m_aCeilVersion) > 0) {
            throw new IllegalArgumentException("Floor version may not be greater than the ceiling version!");
        }
    }

    public VersionRange(@Nonnull Version aFloorVersion, @Nullable Version aCeilingVersion) {
        this(aFloorVersion, true, aCeilingVersion, true);
    }

    public VersionRange(@Nonnull Version aFloorVersion, boolean bIncludeFloorVersion, @Nullable Version aCeilingVersion, boolean bIncludeCeilingVersion) {
        if (aFloorVersion == null) {
            throw new NullPointerException("floorVersion");
        }
        this.m_aFloorVersion = aFloorVersion;
        this.m_bIncludeFloor = bIncludeFloorVersion;
        this.m_aCeilVersion = aCeilingVersion;
        this.m_bIncludeCeil = bIncludeCeilingVersion;
        if (this.m_aCeilVersion != null && this.m_aFloorVersion.compareTo(this.m_aCeilVersion) > 0) {
            throw new IllegalArgumentException("Floor version may not be greater than the ceiling version!");
        }
    }

    public boolean isIncludingFloor() {
        return this.m_bIncludeFloor;
    }

    @Nullable
    public Version getFloorVersion() {
        return this.m_aFloorVersion;
    }

    public boolean isIncludingCeil() {
        return this.m_bIncludeCeil;
    }

    @Nullable
    public Version getCeilVersion() {
        return this.m_aCeilVersion;
    }

    public boolean versionMatches(@Nonnull Version rhs) {
        int i = this.m_aFloorVersion.compareTo(rhs);
        if (this.m_bIncludeFloor ? i > 0 : i >= 0) {
            return false;
        }
        if (this.m_aCeilVersion != null) {
            i = this.m_aCeilVersion.compareTo(rhs);
            if (this.m_bIncludeCeil ? i < 0 : i <= 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(@Nonnull VersionRange rhs) {
        int i = this.m_aFloorVersion.compareTo(rhs.m_aFloorVersion);
        if (i == 0) {
            if (this.m_bIncludeFloor && !rhs.m_bIncludeFloor) {
                i = -1;
            } else if (!this.m_bIncludeFloor && rhs.m_bIncludeFloor) {
                i = 1;
            }
            if (i == 0) {
                if (this.m_aCeilVersion != null && rhs.m_aCeilVersion == null) {
                    i = -1;
                } else if (this.m_aCeilVersion == null && rhs.m_aCeilVersion != null) {
                    i = 1;
                } else if (this.m_aCeilVersion != null && rhs.m_aCeilVersion != null) {
                    i = this.m_aCeilVersion.compareTo(rhs.m_aCeilVersion);
                }
                if (i == 0) {
                    if (this.m_bIncludeCeil && !rhs.m_bIncludeCeil) {
                        i = 1;
                    } else if (!this.m_bIncludeCeil && rhs.m_bIncludeCeil) {
                        i = -1;
                    }
                }
            }
        }
        return i;
    }

    @Override
    @Nonnull
    public String getAsString() {
        return this.getAsString(false);
    }

    @Nonnull
    public String getAsString(boolean bPrintZeroElements) {
        StringBuilder aSB = new StringBuilder(this.m_bIncludeFloor ? "[" : "(");
        aSB.append(this.m_aFloorVersion.getAsString(bPrintZeroElements));
        if (this.m_aCeilVersion != null) {
            aSB.append(',').append(this.m_aCeilVersion.getAsString(bPrintZeroElements));
        }
        return aSB.append(this.m_bIncludeCeil ? (char)']' : ')').toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionRange)) {
            return false;
        }
        VersionRange rhs = (VersionRange)o;
        return this.m_bIncludeFloor == rhs.m_bIncludeFloor && this.m_aFloorVersion.equals(rhs.m_aFloorVersion) && this.m_bIncludeCeil == rhs.m_bIncludeCeil && EqualsUtils.equals(this.m_aCeilVersion, rhs.m_aCeilVersion);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFloorVersion).append(this.m_bIncludeFloor).append(this.m_aCeilVersion).append(this.m_bIncludeCeil).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("floorVersion", this.m_aFloorVersion).append("inclFloor", this.m_bIncludeFloor).append("ceilVersion", this.m_aCeilVersion).append("inclCeil", this.m_bIncludeCeil).toString();
    }
}

