/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.ls;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.xml.ls.ResourceLSInput;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SimpleLSResourceResolver
implements LSResourceResolver {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SimpleLSResourceResolver.class);
    private final LSResourceResolver m_aParentResolver;

    public SimpleLSResourceResolver() {
        this(null);
    }

    public SimpleLSResourceResolver(@Nullable LSResourceResolver aParentResolver) {
        this.m_aParentResolver = aParentResolver;
    }

    @Nonnull
    public static final IReadableResource doStandardResourceResolving(String sSystemId, String sBaseURI) throws URISyntaxException, IOException {
        File aSystemId;
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Trying to resolve  resource " + sSystemId + " from base " + sBaseURI);
        }
        if (sSystemId.contains("://")) {
            return new URLResource(sSystemId);
        }
        if (StringHelper.startsWith((CharSequence)sBaseURI, "jar:file:")) {
            File aParent;
            String sRelativePath;
            int i = sBaseURI.indexOf(33);
            String string = sRelativePath = i < 0 ? sBaseURI : sBaseURI.substring(i + 1);
            if (FilenameHelper.startsWithPathSeparatorChar(sRelativePath)) {
                sRelativePath = sRelativePath.substring(1);
            }
            String sPath = FilenameHelper.getCleanPath((aParent = new File(sRelativePath).getParentFile()) == null ? sSystemId : aParent.getPath() + '/' + sSystemId);
            return new ClassPathResource(sPath);
        }
        URL aBaseURL = null;
        try {
            aBaseURL = new URL(sBaseURI);
            if (!aBaseURL.getProtocol().equals("file")) {
                return new URLResource(FilenameHelper.getCleanConcatenatedUrlPath(sBaseURI, sSystemId));
            }
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        File aBase = aBaseURL != null ? new File(aBaseURL.toURI().getSchemeSpecificPart()) : new File(sBaseURI);
        if (StringHelper.hasNoText(sSystemId)) {
            return new FileSystemResource(aBase);
        }
        try {
            aSystemId = new File(new URL(sSystemId).toURI().getSchemeSpecificPart());
        }
        catch (MalformedURLException ex) {
            aSystemId = new File(sSystemId);
        }
        File aParent = aBase.getParentFile();
        File aRealFile = new File(aParent, aSystemId.getPath());
        return new FileSystemResource(aRealFile);
    }

    @Nullable
    @OverrideOnDemand
    protected IReadableResource internalResolveResource(String sSystemId, String sBaseURI) throws Exception {
        return SimpleLSResourceResolver.doStandardResourceResolving(sSystemId, sBaseURI);
    }

    @Override
    @Nullable
    public final LSInput resolveResource(String sType, String sNamespaceURI, String sPublicId, String sSystemId, String sBaseURI) {
        try {
            IReadableResource aResolvedResource = this.internalResolveResource(sSystemId, sBaseURI);
            if (aResolvedResource != null) {
                return new ResourceLSInput(aResolvedResource);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to resolve resource relative to '" + sBaseURI + "'", ex);
        }
        return this.m_aParentResolver == null ? null : this.m_aParentResolver.resolveResource(sType, sNamespaceURI, sPublicId, sSystemId, sBaseURI);
    }
}

