/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.error.ResourceError;
import com.phloc.commons.error.ResourceLocation;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSAXErrorHandler
implements ErrorHandler {
    private final ErrorHandler m_aWrappedErrorHandler;

    protected AbstractSAXErrorHandler() {
        this(null);
    }

    public AbstractSAXErrorHandler(@Nullable ErrorHandler aWrappedErrorHandler) {
        this.m_aWrappedErrorHandler = aWrappedErrorHandler;
    }

    @Nullable
    public ErrorHandler getWrappedErrorHandler() {
        return this.m_aWrappedErrorHandler;
    }

    @Nonnull
    protected static final IResourceError getSaxParseError(@Nonnull EErrorLevel eErrorLevel, @Nonnull SAXParseException ex) {
        String sResourceID = StringHelper.getConcatenatedOnDemand(ex.getPublicId(), "/", ex.getSystemId());
        ResourceLocation aLocation = new ResourceLocation(sResourceID, ex.getLineNumber(), ex.getColumnNumber());
        return new ResourceError((IResourceLocation)aLocation, eErrorLevel, ex.getMessage());
    }

    protected abstract void internalLog(@Nonnull EErrorLevel var1, @Nonnull SAXParseException var2);

    @Override
    public final void warning(SAXParseException ex) throws SAXException {
        this.internalLog(EErrorLevel.WARN, ex);
        if (this.m_aWrappedErrorHandler != null) {
            this.m_aWrappedErrorHandler.warning(ex);
        }
    }

    @Override
    public final void error(SAXParseException ex) throws SAXException {
        this.internalLog(EErrorLevel.ERROR, ex);
        if (this.m_aWrappedErrorHandler != null) {
            this.m_aWrappedErrorHandler.error(ex);
        }
    }

    @Override
    public final void fatalError(SAXParseException ex) throws SAXException {
        this.internalLog(EErrorLevel.FATAL_ERROR, ex);
        if (this.m_aWrappedErrorHandler != null) {
            this.m_aWrappedErrorHandler.fatalError(ex);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("parentEH", this.m_aWrappedErrorHandler).toString();
    }
}

