/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.schema;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.xml.sax.CollectingSAXErrorHandler;
import com.phloc.commons.xml.schema.XMLSchemaCache;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import javax.annotation.Nonnull;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;

public final class XMLSchemaValidationHelper {
    private static final XMLSchemaValidationHelper s_aInstance = new XMLSchemaValidationHelper();

    private XMLSchemaValidationHelper() {
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull IReadableResource aSchema, @Nonnull IReadableResource aXML) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{aSchema}, aXML);
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull @Nonempty IReadableResource[] aSchemas, @Nonnull IReadableResource aXML) {
        if (aXML == null) {
            throw new NullPointerException("XMLresource");
        }
        return XMLSchemaValidationHelper.validate(aSchemas, (Source)TransformSourceFactory.create(aXML));
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull Schema aSchema, @Nonnull IReadableResource aXML) {
        if (aXML == null) {
            throw new NullPointerException("XMLresource");
        }
        return XMLSchemaValidationHelper.validate(aSchema, (Source)TransformSourceFactory.create(aXML));
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull @Nonempty IReadableResource aSchema, @Nonnull Source aXML) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{aSchema}, aXML);
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull @Nonempty IReadableResource[] aSchemas, @Nonnull Source aXML) {
        return XMLSchemaValidationHelper.validate(XMLSchemaCache.getInstance().getSchema(aSchemas), aXML);
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull Schema aSchema, @Nonnull Source aXML) {
        if (aSchema == null) {
            throw new NullPointerException("schema");
        }
        if (aXML == null) {
            throw new NullPointerException("XMLsource");
        }
        Validator aValidator = aSchema.newValidator();
        CollectingSAXErrorHandler aErrHdl = new CollectingSAXErrorHandler();
        aValidator.setErrorHandler(aErrHdl);
        try {
            aValidator.validate(aXML, null);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to validate the XML " + aXML + " against " + aSchema, ex);
        }
        return aErrHdl.getResourceErrors();
    }
}

