/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.xpath;

import com.phloc.commons.string.StringHelper;
import com.phloc.commons.xml.xpath.XPathHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NotThreadSafe
public final class XPathExpressionHelper {
    private XPathExpressionHelper() {
    }

    @Nullable
    public static Object evalXPath(@Nullable XPathVariableResolver aVariableResolver, @Nullable XPathFunctionResolver aFunctionResolver, @Nullable NamespaceContext aNamespaceContext, @Nonnull String sXPath, @Nonnull Document aDoc, @Nonnull QName aReturnType) {
        return XPathExpressionHelper.evalXPath(XPathHelper.createNewXPath(aVariableResolver, aFunctionResolver, aNamespaceContext), sXPath, aDoc, aReturnType);
    }

    @Nullable
    public static Object evalXPath(@Nonnull XPath aXPath, @Nonnull String sXPath, @Nonnull Document aDoc, @Nonnull QName aReturnType) {
        if (aXPath == null) {
            throw new NullPointerException("XPath");
        }
        if (StringHelper.hasNoText(sXPath)) {
            throw new IllegalArgumentException("XPath");
        }
        if (aDoc == null) {
            throw new NullPointerException("doc");
        }
        if (aReturnType == null) {
            throw new NullPointerException("returnType");
        }
        try {
            XPathExpression aXPathExpression = XPathHelper.createNewXPathExpresion(aXPath, sXPath);
            return aXPathExpression.evaluate(aDoc, aReturnType);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Failed to evaluate XPath expression '" + sXPath + "' with return type " + aReturnType.toString(), ex);
        }
    }

    @Nullable
    public static Double evalXPathToNumber(@Nullable XPathVariableResolver aVariableResolver, @Nullable XPathFunctionResolver aFunctionResolver, @Nullable NamespaceContext aNamespaceContext, @Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToNumber(XPathHelper.createNewXPath(aVariableResolver, aFunctionResolver, aNamespaceContext), sXPath, aDoc);
    }

    @Nullable
    public static Double evalXPathToNumber(@Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToNumber(XPathHelper.createNewXPath(), sXPath, aDoc);
    }

    @Nullable
    public static Double evalXPathToNumber(@Nonnull XPath aXPath, @Nonnull String sXPath, @Nonnull Document aDoc) {
        Object aResult = XPathExpressionHelper.evalXPath(aXPath, sXPath, aDoc, XPathConstants.NUMBER);
        return (Double)aResult;
    }

    @Nullable
    public static String evalXPathToString(@Nullable XPathVariableResolver aVariableResolver, @Nullable XPathFunctionResolver aFunctionResolver, @Nullable NamespaceContext aNamespaceContext, @Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToString(XPathHelper.createNewXPath(aVariableResolver, aFunctionResolver, aNamespaceContext), sXPath, aDoc);
    }

    @Nullable
    public static String evalXPathToString(@Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToString(XPathHelper.createNewXPath(), sXPath, aDoc);
    }

    @Nullable
    public static String evalXPathToString(@Nonnull XPath aXPath, @Nonnull String sXPath, @Nonnull Document aDoc) {
        Object aResult = XPathExpressionHelper.evalXPath(aXPath, sXPath, aDoc, XPathConstants.STRING);
        return (String)aResult;
    }

    @Nullable
    public static Boolean evalXPathToBoolean(@Nullable XPathVariableResolver aVariableResolver, @Nullable XPathFunctionResolver aFunctionResolver, @Nullable NamespaceContext aNamespaceContext, @Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToBoolean(XPathHelper.createNewXPath(aVariableResolver, aFunctionResolver, aNamespaceContext), sXPath, aDoc);
    }

    @Nullable
    public static Boolean evalXPathToBoolean(@Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToBoolean(XPathHelper.createNewXPath(), sXPath, aDoc);
    }

    @Nullable
    public static Boolean evalXPathToBoolean(@Nonnull XPath aXPath, @Nonnull String sXPath, @Nonnull Document aDoc) {
        Object aResult = XPathExpressionHelper.evalXPath(aXPath, sXPath, aDoc, XPathConstants.BOOLEAN);
        return (Boolean)aResult;
    }

    @Nullable
    public static NodeList evalXPathToNodeList(@Nullable XPathVariableResolver aVariableResolver, @Nullable XPathFunctionResolver aFunctionResolver, @Nullable NamespaceContext aNamespaceContext, @Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToNodeList(XPathHelper.createNewXPath(aVariableResolver, aFunctionResolver, aNamespaceContext), sXPath, aDoc);
    }

    @Nullable
    public static NodeList evalXPathToNodeList(@Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToNodeList(XPathHelper.createNewXPath(), sXPath, aDoc);
    }

    @Nullable
    public static NodeList evalXPathToNodeList(@Nonnull XPath aXPath, @Nonnull String sXPath, @Nonnull Document aDoc) {
        Object aResult = XPathExpressionHelper.evalXPath(aXPath, sXPath, aDoc, XPathConstants.NODESET);
        return (NodeList)aResult;
    }

    @Nullable
    public static Node evalXPathToNode(@Nullable XPathVariableResolver aVariableResolver, @Nullable XPathFunctionResolver aFunctionResolver, @Nullable NamespaceContext aNamespaceContext, @Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToNode(XPathHelper.createNewXPath(aVariableResolver, aFunctionResolver, aNamespaceContext), sXPath, aDoc);
    }

    @Nullable
    public static Node evalXPathToNode(@Nonnull String sXPath, @Nonnull Document aDoc) {
        return XPathExpressionHelper.evalXPathToNode(XPathHelper.createNewXPath(), sXPath, aDoc);
    }

    @Nullable
    public static Node evalXPathToNode(@Nonnull XPath aXPath, @Nonnull String sXPath, @Nonnull Document aDoc) {
        Object aResult = XPathExpressionHelper.evalXPath(aXPath, sXPath, aDoc, XPathConstants.NODE);
        return (Node)aResult;
    }
}

