/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.name.IHasName;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSExpressionMathMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSMathOperator implements ICSSExpressionMathMember,
IHasName
{
    PLUS("+", " + "),
    MINUS("-", " - "),
    MULTIPLY("*", "*"),
    DIVIDE("/", "/");

    private final String m_sName;
    private final String m_sText;

    private ECSSMathOperator(String sName, String sText) {
        this.m_sName = sName;
        this.m_sText = sText;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return this.m_sText;
    }

    @Nullable
    public static ECSSMathOperator getFromNameOrNull(@Nullable String sName) {
        return (ECSSMathOperator)EnumHelper.getFromNameOrNull(ECSSMathOperator.class, (String)sName);
    }
}

