/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.string.StringParser;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.property.CSSPropertyFree;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.propertyvalue.CSSValue;
import com.phloc.css.propertyvalue.CSSValueList;
import com.phloc.css.propertyvalue.CSSValueMultiProperty;
import com.phloc.css.propertyvalue.CSSValueMultiValue;
import com.phloc.css.propertyvalue.ICSSValue;
import com.phloc.css.utils.ICSSNamedColor;
import javax.annotation.Nonnull;

public abstract class AbstractCSSProperty
implements ICSSProperty {
    private final ECSSProperty m_eProp;

    protected AbstractCSSProperty(@Nonnull ECSSProperty eProp) {
        if (eProp == null) {
            throw new NullPointerException("prop");
        }
        this.m_eProp = eProp;
    }

    @Override
    @Nonnull
    public final ECSSVersion getMinimumCSSVersion() {
        return this.m_eProp.getMinimumCSSVersion();
    }

    @Override
    @Nonnull
    public final ECSSProperty getProp() {
        return this.m_eProp;
    }

    @Nonnull
    private ICSSValue _newValue(@Nonnull String sValue, boolean bIsImportant) {
        if (sValue == null) {
            throw new NullPointerException("value");
        }
        switch (this.m_eProp) {
            case DISPLAY: {
                if (!sValue.equals("inline-block")) break;
                return new CSSValueMultiValue(this, new String[]{"-moz-inline-block", sValue}, bIsImportant);
            }
            case OPACITY: {
                double dValue = StringParser.parseDouble((String)sValue, (double)Double.NaN);
                if (Double.isNaN(dValue)) break;
                int nPerc = (int)(dValue * 100.0);
                return new CSSValueList(new ICSSProperty[]{new CSSPropertyFree(ECSSProperty._MS_FILTER), new CSSPropertyFree(ECSSProperty.FILTER), this.getClone(ECSSProperty._MOZ_OPACITY), this.getClone(ECSSProperty._WEBKIT_OPACITY), this}, new String[]{"\"progid:DXImageTransform.Microsoft.Alpha(Opacity=" + nPerc + ")\"", "alpha(opacity=" + nPerc + ")", sValue, sValue, sValue}, bIsImportant);
            }
            case BORDER_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS), this.getClone(ECSSProperty._WEBKIT_BORDER_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_RADIUS)}, sValue, bIsImportant);
            }
            case BORDER_TOP_LEFT_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS_TOPLEFT), this.getClone(ECSSProperty._WEBKIT_BORDER_TOP_LEFT_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_TOP_LEFT_RADIUS)}, sValue, bIsImportant);
            }
            case BORDER_TOP_RIGHT_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS_TOPRIGHT), this.getClone(ECSSProperty._WEBKIT_BORDER_TOP_RIGHT_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_TOP_RIGHT_RADIUS)}, sValue, bIsImportant);
            }
            case BORDER_BOTTOM_LEFT_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS_BOTTOMLEFT), this.getClone(ECSSProperty._WEBKIT_BORDER_BOTTOM_LEFT_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_BOTTOM_LEFT_RADIUS)}, sValue, bIsImportant);
            }
            case BORDER_BOTTOM_RIGHT_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS_BOTTOMRIGHT), this.getClone(ECSSProperty._WEBKIT_BORDER_BOTTOM_RIGHT_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_BOTTOM_RIGHT_RADIUS)}, sValue, bIsImportant);
            }
        }
        return new CSSValue(this, sValue, bIsImportant);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull String sValue) {
        return this._newValue(sValue, false);
    }

    @Override
    @Nonnull
    public final ICSSValue newImportantValue(@Nonnull String sValue) {
        return this._newValue(sValue, true);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull ICSSNamedColor aColor) {
        return this.newValue(aColor.getName());
    }

    @Override
    @Nonnull
    public final ICSSValue newImportantValue(@Nonnull ICSSNamedColor aColor) {
        return this.newImportantValue(aColor.getName());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("prop", (Enum)this.m_eProp).toString();
    }
}

