/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.CSSPropertyEnum;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.utils.CSSNumberHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSPropertyEnumOrNumber
extends CSSPropertyEnum {
    private final boolean m_bWithPercentage;

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eProp, boolean bWithPercentage, String ... aEnumValues) {
        super(eProp, aEnumValues);
        this.m_bWithPercentage = bWithPercentage;
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eProp, boolean bWithPercentage, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, aEnumValues);
        this.m_bWithPercentage = bWithPercentage;
    }

    @Override
    public boolean isValidValue(@Nullable String sValue) {
        return super.isValidValue(sValue) || CSSNumberHelper.isNumberWithUnitValue(sValue, this.m_bWithPercentage);
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrNumber getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnumOrNumber(eProp, this.m_bWithPercentage, this.m_aEnumValues);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).toString();
    }
}

