/*
 * Decompiled with CFR 0.152.
 */
package com.schematron.ant;

import com.schematron.ant.SchematronReport;
import com.schematron.ant.SchematronResult;
import com.schematron.ant.Validator;
import com.schematron.ant.ValidatorFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class SchematronTask
extends Task {
    private String queryLanguageBinding = "auto";
    private String format = "svrl";
    private String phase;
    private File schema;
    private String outputDir;
    private String outputFilename = "result.xml";
    private File file;
    private final ArrayList<FileSet> filesets = new ArrayList();
    private Validator validator;
    private boolean failOnError = true;
    private boolean debugMode = false;
    private String allow_foreign;
    private String sch_exlst_imports;
    private String message_newline;
    private String attributes;
    private String only_child_elements;
    private String visit_text;
    private String select_contents;
    private String generate_paths;
    private String diagnose;
    private String terminate;
    private String langCode;
    private String schema_id;
    private String resolver;
    private String archiveNameParameter = null;
    private String archiveDirParameter = null;
    private String fileNameParameter = null;
    private String fileDirParameter = null;
    private Path classpath = null;
    private String encoding = null;
    private AntClassLoader loader = null;

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setQueryLanguageBinding(String binding) {
        this.queryLanguageBinding = binding;
    }

    public void setFormat(String theFormat) {
        this.format = theFormat;
    }

    public void setDebugMode(boolean debug) {
        this.debugMode = debug;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public void setSchema(File file) {
        this.schema = file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public void setCatalog(String data) {
        System.setProperty("xml.catalog.files", data);
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setAllow_foreign(String value) {
        this.allow_foreign = value;
    }

    public void setSch_exlst_imports(String value) {
        this.sch_exlst_imports = value;
    }

    public void setMessage_newline(String value) {
        this.message_newline = value;
    }

    public void setAttributes(String value) {
        this.attributes = value;
    }

    public void setOnly_child_elements(String value) {
        this.only_child_elements = value;
    }

    public void setVisit_text(String value) {
        this.visit_text = value;
    }

    public void setSelect_contents(String value) {
        this.select_contents = value;
    }

    public void setGenerate_paths(String value) {
        this.generate_paths = value;
    }

    public void setDiagnose(String value) {
        this.diagnose = value;
    }

    public void setTerminate(String value) {
        this.terminate = value;
    }

    public void setSchema_id(String value) {
        this.schema_id = value;
    }

    public void setLangCode(String value) {
        this.langCode = value;
    }

    public void setResolver(String value) {
        this.resolver = value;
    }

    public void setFileNameParameter(String value) {
        this.fileNameParameter = value;
    }

    public void setFileDirParameter(String value) {
        this.fileDirParameter = value;
    }

    public void setArchiveNameParameter(String value) {
        this.archiveNameParameter = value;
    }

    public void setarchiveDirParameter(String value) {
        this.archiveDirParameter = value;
    }

    public void setOutputEncoding(String value) {
        this.encoding = value;
    }

    public void execute() throws BuildException {
        int fileProcessed = 0;
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.schema == null) {
            throw new BuildException("Specify at least one schema.");
        }
        if (!(this.schema.exists() && this.schema.canRead() && this.schema.isFile())) {
            throw new BuildException("Schema " + this.schema + " cannot be read");
        }
        this.initValidator();
        SchematronReport report = new SchematronReport();
        if (this.file != null) {
            if (this.file.exists() && this.file.canRead() && this.file.isFile()) {
                SchematronResult result = this.doValidate(this.file);
                report.add(result);
                ++fileProcessed;
            } else {
                String message = "File " + this.file + " cannot be read";
                if (this.failOnError) {
                    throw new BuildException(message);
                }
                this.log(message, 0);
            }
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = this.filesets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            int j = 0;
            while (j < files.length) {
                File srcFile = new File(fs.getDir(this.getProject()), files[j]);
                SchematronResult result = this.doValidate(srcFile);
                if (this.failOnError && !result.isValid()) {
                    result.printFailedMessage(this);
                    return;
                }
                report.add(result);
                ++fileProcessed;
                Thread.yield();
                ++j;
            }
            ++i;
        }
        try {
            try {
                File resultFile = new File(this.outputDir, this.outputFilename);
                report.saveAs(resultFile);
            }
            catch (IOException ex) {
                throw new BuildException("Unable to write to file: " + ex.getMessage());
            }
        }
        finally {
            if (this.loader != null) {
                this.loader.resetThreadContextLoader();
                this.loader.cleanup();
                this.loader = null;
            }
        }
        try {
            report.printLog(this);
        }
        catch (Exception ex) {
            throw new BuildException(ex.getMessage());
        }
        this.log(String.valueOf(fileProcessed) + " file(s) have been successfully validated.");
    }

    private void initValidator() throws BuildException {
        try {
            System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
            ValidatorFactory factory = new ValidatorFactory(this.queryLanguageBinding, this.format);
            if (this.resolver != null && this.resolver.length() > 0) {
                factory.setResolver(this.loadClass(this.resolver));
            }
            factory.setDebugMode(this.debugMode);
            factory.setErrorListener(new Listener());
            if (this.phase != null) {
                factory.setParameter("phase", this.phase);
            }
            if (this.allow_foreign != null) {
                factory.setParameter("allow-foreign", this.allow_foreign);
            }
            if (this.sch_exlst_imports != null) {
                factory.setParameter("sch.exslt.imports", this.sch_exlst_imports);
            }
            if (this.message_newline != null) {
                factory.setParameter("message-newline", this.message_newline);
            }
            if (this.attributes != null) {
                factory.setParameter("attributes", this.attributes);
            }
            if (this.only_child_elements != null) {
                factory.setParameter("only-child-elements", this.only_child_elements);
            }
            if (this.visit_text != null) {
                factory.setParameter("visit-text", this.visit_text);
            }
            if (this.select_contents != null) {
                factory.setParameter("select-contents", this.select_contents);
            }
            if (this.generate_paths != null) {
                factory.setParameter("generate-paths", this.generate_paths);
            }
            if (this.diagnose != null) {
                factory.setParameter("diagnose", this.diagnose);
            }
            if (this.terminate != null) {
                factory.setParameter("terminate", this.terminate);
            }
            if (this.schema_id != null) {
                factory.setParameter("schema-id", this.schema_id);
            }
            if (this.encoding != null) {
                factory.setParameter("output-encoding", this.encoding);
            }
            if (this.langCode != null) {
                factory.setParameter("langCode", this.langCode);
            }
            this.log("Generating validator for schema " + this.schema + "... ", 3);
            this.validator = factory.newValidator(new StreamSource(this.schema));
            this.log("Validator ready to process", 3);
        }
        catch (TransformerException ex) {
            this.log(ex.getMessage());
            SourceLocator locator = ex.getLocator();
            if (locator != null) {
                this.log("SystemID: " + locator.getSystemId() + "; Line#: " + locator.getLineNumber() + "; Column#: " + locator.getColumnNumber());
            }
            throw new BuildException("The validator could not be initialised", (Throwable)ex);
        }
        catch (IOException io) {
            this.log("Error when outputting preprocessor stylesheet: " + io.getMessage());
        }
        catch (Exception e) {
            this.log("Error with initializing validator: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private SchematronResult doValidate(File afile) {
        try {
            this.log("Validating " + afile.getName() + "... ", 3);
            StreamSource xml = new StreamSource(afile);
            SchematronResult result = this.validator.validate(xml, this.fileNameParameter, this.fileDirParameter, this.archiveNameParameter, this.archiveDirParameter, this.encoding);
            return result;
        }
        catch (TransformerConfigurationException ex) {
            throw new BuildException("Could not instantiate validator for document " + afile);
        }
        catch (TransformerException ex) {
            if (this.failOnError) {
                throw new BuildException("Could not validate document " + afile, (Throwable)ex);
            }
            System.err.println("DEBUG: error");
            this.log("Could not validate document " + afile);
            this.log(ex.getMessage());
            SourceLocator locator = ex.getLocator();
            if (locator != null) {
                this.log("SystemID: " + locator.getSystemId() + "; Line#: " + locator.getLineNumber() + "; Column#: " + locator.getColumnNumber());
            }
            return null;
        }
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    private Class loadClass(String classname) throws Exception {
        if (this.classpath == null) {
            return Class.forName(classname);
        }
        this.loader = this.getProject().createClassLoader(this.classpath);
        this.loader.setThreadContextLoader();
        return Class.forName(classname, true, (ClassLoader)this.loader);
    }

    private class Listener
    implements ErrorListener {
        private Listener() {
        }

        public void warning(TransformerException ex) {
            SchematronTask.this.log(ex.getMessage());
        }

        public void error(TransformerException ex) throws TransformerException {
            throw ex;
        }

        public void fatalError(TransformerException ex) throws TransformerException {
            throw ex;
        }
    }
}

