/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.w3c.tools.codec.Base64FormatException;

public class Base64Decoder {
    private static final int BUFFER_SIZE = 1024;
    InputStream in = null;
    OutputStream out = null;
    boolean stringp = false;

    private void printHex(int n) {
        int n2 = (n & 0xF0) >> 4;
        int n3 = n & 0xF;
        System.out.print(new Character((char)(n2 > 9 ? 65 + n2 - 10 : 48 + n2)).toString() + new Character((char)(n3 > 9 ? 65 + n3 - 10 : 48 + n3)).toString());
    }

    private void printHex(byte[] byArray, int n, int n2) {
        while (n < n2) {
            this.printHex(byArray[n++]);
            System.out.print(" ");
        }
        System.out.println("");
    }

    private void printHex(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + "[printHex] Unable to convert" + "properly char to bytes");
        }
        this.printHex(byArray, 0, byArray.length);
    }

    private final int get1(byte[] byArray, int n) {
        return (byArray[n] & 0x3F) << 2 | (byArray[n + 1] & 0x30) >>> 4;
    }

    private final int get2(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xF) << 4 | (byArray[n + 2] & 0x3C) >>> 2;
    }

    private final int get3(byte[] byArray, int n) {
        return (byArray[n + 2] & 3) << 6 | byArray[n + 3] & 0x3F;
    }

    private final int check(int n) {
        if (n >= 65 && n <= 90) {
            return n - 65;
        }
        if (n >= 97 && n <= 122) {
            return n - 97 + 26;
        }
        if (n >= 48 && n <= 57) {
            return n - 48 + 52;
        }
        switch (n) {
            case 61: {
                return 65;
            }
            case 43: {
                return 62;
            }
            case 47: {
                return 63;
            }
        }
        return -1;
    }

    public void process() throws IOException, Base64FormatException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4];
        int n = -1;
        int n2 = 0;
        block0: while ((n = this.in.read(byArray)) > 0) {
            int n3 = 0;
            while (n3 < n) {
                while (n2 < 4) {
                    int n4;
                    if (n3 >= n) continue block0;
                    if ((n4 = this.check(byArray[n3++])) < 0) continue;
                    byArray2[n2++] = (byte)n4;
                }
                if (byArray2[2] == 65) {
                    this.out.write(this.get1(byArray2, 0));
                    return;
                }
                if (byArray2[3] == 65) {
                    this.out.write(this.get1(byArray2, 0));
                    this.out.write(this.get2(byArray2, 0));
                    return;
                }
                this.out.write(this.get1(byArray2, 0));
                this.out.write(this.get2(byArray2, 0));
                this.out.write(this.get3(byArray2, 0));
                n2 = 0;
            }
        }
        if (n2 != 0) {
            throw new Base64FormatException("Invalid length.");
        }
        this.out.flush();
    }

    public String processString() throws Base64FormatException {
        String string;
        if (!this.stringp) {
            throw new RuntimeException(this.getClass().getName() + "[processString]" + "invalid call (not a String)");
        }
        try {
            this.process();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            string = ((ByteArrayOutputStream)this.out).toString("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + "[processString] Unable to convert" + "properly char to bytes");
        }
        return string;
    }

    public Base64Decoder(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + "[Constructor] Unable to convert" + "properly char to bytes");
        }
        this.stringp = true;
        this.in = new ByteArrayInputStream(byArray);
        this.out = new ByteArrayOutputStream();
    }

    public Base64Decoder(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
        this.stringp = false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            try {
                Base64Decoder base64Decoder = new Base64Decoder(stringArray[0]);
                System.out.println("[" + base64Decoder.processString() + "]");
            }
            catch (Base64FormatException base64FormatException) {
                System.out.println("Invalid Base64 format !");
                System.exit(1);
            }
        } else if (stringArray.length == 2 && stringArray[0].equals("-f")) {
            try {
                FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
                Base64Decoder base64Decoder = new Base64Decoder(fileInputStream, System.out);
                base64Decoder.process();
            }
            catch (Exception exception) {
                System.out.println("error: " + exception.getMessage());
                System.exit(1);
            }
        } else {
            System.out.println("Base64Decoder [strong] [-f file]");
        }
        System.exit(0);
    }
}

