/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.serialization.ResourceDescription;
import org.w3c.tools.resources.serialization.SerializationException;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.serialization.xml.JigXML;
import org.w3c.tools.resources.serialization.xml.XMLDescrReader;
import org.w3c.tools.resources.serialization.xml.XMLDescrWriter;
import org.w3c.tools.resources.serialization.xml.XMLReader;
import org.w3c.tools.resources.serialization.xml.XMLResourceWriter;
import org.w3c.tools.resources.serialization.xml.XMLSubsetReader;
import org.w3c.util.LookupTable;
import org.xml.sax.Parser;

public class XMLSerializer
implements Serializer,
JigXML {
    public static final String PARSER_P1 = "com.bluecast.xml.Piccolo";
    public static final String PARSER_P2 = "com.jclark.xml.sax.Driver";
    public static final String PARSER_P3 = "org.apache.xerces.parsers.SAXParser";
    protected Class parser_class = null;
    protected String parser_name = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResourceDescriptions(ResourceDescription[] resourceDescriptionArray, Writer writer) throws IOException, SerializationException {
        XMLDescrWriter xMLDescrWriter = null;
        try {
            xMLDescrWriter = new XMLDescrWriter(writer);
            xMLDescrWriter.startDocument();
            for (int i = 0; i < resourceDescriptionArray.length; ++i) {
                xMLDescrWriter.writeResourceDescription(resourceDescriptionArray[i]);
            }
        }
        finally {
            if (xMLDescrWriter != null) {
                xMLDescrWriter.closeDocument();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResourceDescriptions(Resource[] resourceArray, Writer writer) throws IOException, SerializationException {
        XMLResourceWriter xMLResourceWriter = null;
        try {
            xMLResourceWriter = new XMLResourceWriter(writer);
            xMLResourceWriter.startDocument();
            for (int i = 0; i < resourceArray.length; ++i) {
                xMLResourceWriter.writeResourceDescription(resourceArray[i]);
            }
        }
        finally {
            if (xMLResourceWriter != null) {
                xMLResourceWriter.closeDocument();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResources(AttributeHolder[] attributeHolderArray, Writer writer) throws IOException, SerializationException {
        XMLResourceWriter xMLResourceWriter = null;
        try {
            xMLResourceWriter = new XMLResourceWriter(writer);
            xMLResourceWriter.startDocument();
            for (int i = 0; i < attributeHolderArray.length; ++i) {
                xMLResourceWriter.writeResource(attributeHolderArray[i]);
            }
        }
        finally {
            if (xMLResourceWriter != null) {
                xMLResourceWriter.closeDocument();
            }
        }
    }

    protected Parser getParser() throws SerializationException {
        try {
            return (Parser)this.parser_class.newInstance();
        }
        catch (Exception exception) {
            throw new SerializationException("Unable to intantiate : " + this.parser_name);
        }
    }

    public ResourceDescription[] readResourceDescriptions(Reader reader) throws IOException, SerializationException {
        Parser parser = this.getParser();
        XMLDescrReader xMLDescrReader = new XMLDescrReader(reader, parser);
        return xMLDescrReader.readResourceDescriptions();
    }

    public Resource[] readResources(Reader reader) throws IOException, SerializationException {
        Parser parser = this.getParser();
        XMLReader xMLReader = new XMLReader(reader, parser);
        return xMLReader.readResources();
    }

    public AttributeHolder[] readAttributeHolders(Reader reader) throws IOException, SerializationException {
        Parser parser = this.getParser();
        XMLReader xMLReader = new XMLReader(reader, parser);
        return xMLReader.readAttributeHolders();
    }

    public LookupTable[] readAttributes(Reader reader, String[] stringArray) throws IOException, SerializationException {
        Parser parser = this.getParser();
        XMLSubsetReader xMLSubsetReader = new XMLSubsetReader(reader, parser, stringArray);
        return xMLSubsetReader.readAttributeTables();
    }

    public XMLSerializer() {
        try {
            this.parser_class = Class.forName(PARSER_P1);
            this.parser_name = PARSER_P1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                this.parser_class = Class.forName(PARSER_P2);
                this.parser_name = PARSER_P2;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    this.parser_class = Class.forName(PARSER_P3);
                    this.parser_name = PARSER_P3;
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    this.parser_class = null;
                }
            }
        }
    }
}

