/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import java.io.DataInputStream;
import java.io.PrintStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.util.ArrayEnumeration;

public class ArrayDictionary
extends Dictionary
implements Cloneable {
    protected Object[] keys;
    protected Object[] values;
    protected int nelems;
    protected int incr;

    public ArrayDictionary() {
        this(10, 10);
    }

    public ArrayDictionary(int n) {
        this(n, n);
    }

    public Object clone() {
        try {
            ArrayDictionary arrayDictionary = (ArrayDictionary)super.clone();
            arrayDictionary.values = new Object[this.values.length];
            System.arraycopy(this.values, 0, arrayDictionary.values, 0, this.values.length);
            arrayDictionary.keys = new Object[this.values.length];
            System.arraycopy(this.keys, 0, arrayDictionary.keys, 0, this.keys.length);
            return arrayDictionary;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ArrayDictionary(int n, int n2) {
        this.keys = new Object[n];
        this.values = new Object[n];
        this.incr = n2;
        this.nelems = 0;
    }

    public ArrayDictionary(Vector vector, Vector vector2) {
        this(vector, vector2, vector2.size());
    }

    public ArrayDictionary(Vector vector, Vector vector2, int n) {
        this.incr = n;
        this.nelems = vector.size();
        this.keys = new Object[this.nelems];
        this.values = new Object[this.nelems];
        vector.copyInto(this.keys);
        vector2.copyInto(this.values);
    }

    public ArrayDictionary(Object[] objectArray, Object[] objectArray2) {
        this(objectArray, objectArray2, objectArray2.length);
    }

    public ArrayDictionary(Object[] objectArray, Object[] objectArray2, int n) {
        this.incr = n;
        this.nelems = objectArray.length;
        this.keys = objectArray;
        this.values = objectArray2;
    }

    protected final void grow() {
        this.grow(this.keys.length + this.incr);
    }

    protected void grow(int n) {
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        System.arraycopy(this.keys, 0, objectArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray2, 0, this.values.length);
        this.keys = objectArray;
        this.values = objectArray2;
    }

    public Enumeration elements() {
        return new ArrayEnumeration(this.values, this.nelems);
    }

    public Object get(Object object) {
        int n = 0;
        for (int i = 0; i < this.keys.length && n < this.nelems; ++i) {
            if (this.keys[i] == null) continue;
            if (this.keys[i].equals(object)) {
                return this.values[i];
            }
            ++n;
        }
        return null;
    }

    public Object[] getMany(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        for (int i = 0; i < this.keys.length && n < this.nelems; ++i) {
            if (this.keys[i] == null) continue;
            for (int j = 0; j < objectArray.length; ++j) {
                if (!this.keys[i].equals(objectArray[j])) continue;
                objectArray2[j] = this.values[i];
                break;
            }
            ++n;
        }
        return objectArray2;
    }

    public final boolean isEmpty() {
        return this.nelems == 0;
    }

    public final void ensureCapacity(int n) {
        if (n > this.keys.length) {
            this.grow(n);
        }
    }

    public Enumeration keys() {
        return new ArrayEnumeration(this.keys, this.nelems);
    }

    public Object put(Object object, Object object2) {
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < this.keys.length && n2 < this.nelems; ++i) {
            if (this.keys[i] == null) {
                n = i;
                continue;
            }
            if (this.keys[i].equals(object)) {
                Object object3 = this.values[i];
                this.values[i] = object2;
                return object3;
            }
            ++n2;
        }
        if (n != -1) {
            this.keys[n] = object;
            this.values[n] = object2;
            ++this.nelems;
        } else {
            this.grow();
            this.keys[this.nelems] = object;
            this.values[this.nelems++] = object2;
        }
        return null;
    }

    public Object remove(Object object) {
        int n = 0;
        for (int i = 0; i < this.keys.length && n < this.nelems; ++i) {
            if (this.keys[i] == null) continue;
            if (this.keys[i].equals(object)) {
                --this.nelems;
                Object object2 = this.values[i];
                this.values[i] = null;
                this.keys[i] = null;
                return object2;
            }
            ++n;
        }
        return null;
    }

    public final int size() {
        return this.nelems;
    }

    public final int capacity() {
        return this.keys.length;
    }

    public final Object keyAt(int n) {
        return this.keys[n];
    }

    public final Object elementAt(int n) {
        return this.values[n];
    }

    public Object setElementAt(int n, Object object) {
        Object object2 = this.values[n];
        this.values[n] = object;
        return object2;
    }

    public Object removeElementAt(int n) {
        if (this.values[n] != null) {
            Object object = this.values[n];
            this.keys[n] = null;
            this.values[n] = null;
            --this.nelems;
            return object;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append('[');
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            stringBuffer.append(this.keys[i]);
            stringBuffer.append('=');
            stringBuffer.append(this.values[i]);
            stringBuffer.append(' ');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            PrintStream printStream = System.out;
            DataInputStream dataInputStream = new DataInputStream(System.in);
            String string = null;
            printStream.print("n ? ");
            printStream.flush();
            string = dataInputStream.readLine();
            int n = Integer.parseInt(string);
            ArrayDictionary arrayDictionary = new ArrayDictionary(n);
            String string2 = null;
            String string3 = null;
            while (true) {
                printStream.print("action ? ");
                printStream.flush();
                string = dataInputStream.readLine();
                switch (string.charAt(0)) {
                    case 'P': 
                    case 'p': {
                        printStream.print("key ? ");
                        printStream.flush();
                        string2 = dataInputStream.readLine();
                        printStream.print("value ? ");
                        printStream.flush();
                        string3 = dataInputStream.readLine();
                        string3 = (String)arrayDictionary.put(string2, string3);
                        printStream.println("old: " + string3);
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        printStream.print("key ? ");
                        printStream.flush();
                        string2 = dataInputStream.readLine();
                        string3 = (String)arrayDictionary.remove(string2);
                        printStream.println("old: " + string3);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        printStream.print("key ? ");
                        printStream.flush();
                        string2 = dataInputStream.readLine();
                        string3 = (String)arrayDictionary.get(string2);
                        printStream.println("value: " + string3);
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        printStream.println(arrayDictionary.toString());
                        break;
                    }
                    case 'Q': 
                    case 'q': {
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

