/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.auth;

import java.awt.Button;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import org.w3c.www.http.HttpChallenge;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.auth.PasswordField;
import org.w3c.www.protocol.http.auth.UserField;

class PasswordPrompter
extends Panel {
    TextField txtUser = null;
    TextField txtPassword = null;
    Button butOk = null;
    Button butCancel = null;
    String user = null;
    String password = null;
    static final int EVT_OK = 1;
    static final int EVT_CANCEL = 2;
    int evt = -1;

    protected synchronized boolean waitForCompletion() {
        while (true) {
            if (this.evt < 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            switch (this.evt) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        }
    }

    protected synchronized void done(int n) {
        this.evt = n;
        this.notifyAll();
    }

    protected void focusPassword() {
        this.txtPassword.requestFocus();
    }

    public boolean action(Event event, Object object) {
        int n = -1;
        if (event.target == this.butOk) {
            n = 1;
        } else if (event.target == this.butCancel) {
            n = 2;
        } else {
            return super.action(event, object);
        }
        this.done(n);
        return true;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean prompt() {
        Frame frame = new Frame("Authentication Required");
        frame.add("Center", this);
        frame.pack();
        frame.show();
        this.txtUser.requestFocus();
        boolean bl = this.waitForCompletion();
        this.user = this.txtUser.getText();
        this.password = this.txtPassword.getText();
        frame.hide();
        frame.dispose();
        return bl;
    }

    PasswordPrompter(Request request, Reply reply) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        HttpChallenge httpChallenge = request.hasProxy() ? reply.getProxyAuthenticate() : reply.getWWWAuthenticate();
        Label label = new Label(httpChallenge.getScheme() + " authentication for " + httpChallenge.getAuthParameter("realm"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = -1;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.weighty = 1.0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = -1;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        label = new Label("User:", 0);
        gridBagLayout.setConstraints(label, gridBagConstraints2);
        this.add(label);
        this.txtUser = new UserField(this, "", 32);
        gridBagLayout.setConstraints(this.txtUser, gridBagConstraints3);
        this.add(this.txtUser);
        label = new Label("Password:", 0);
        gridBagLayout.setConstraints(label, gridBagConstraints2);
        this.add(label);
        this.txtPassword = new PasswordField(this, "", 32);
        gridBagLayout.setConstraints(this.txtPassword, gridBagConstraints3);
        this.add(this.txtPassword);
        this.butOk = new Button("Ok");
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.butOk, gridBagConstraints);
        this.add(this.butOk);
        this.butCancel = new Button("Cancel");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.add(this.butCancel);
    }
}

