/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cookies;

import java.io.File;
import java.io.FileNotFoundException;
import org.w3c.util.ObservableProperties;
import org.w3c.www.http.HttpCookieList;
import org.w3c.www.http.HttpSetCookie;
import org.w3c.www.http.HttpSetCookieList;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cookies.DomainTree;

public class CookieFilter
implements PropRequestFilter {
    public static final String COOKIES_FILE_P = "org.w3c.www.protocol.http.cookie.file";
    private static final String defaultFileName = "cookie";
    private static DomainTree root = null;
    protected HttpManager manager = null;
    private static File cookiefile;

    public Reply ingoingFilter(Request request) throws HttpException {
        HttpCookieList httpCookieList = root.getCookies(request.getURL());
        if (httpCookieList != null) {
            request.setCookie(httpCookieList);
        }
        return null;
    }

    public Reply outgoingFilter(Request request, Reply reply) throws HttpException {
        HttpSetCookie[] httpSetCookieArray;
        HttpSetCookieList httpSetCookieList = reply.getSetCookie();
        if (httpSetCookieList != null && (httpSetCookieArray = httpSetCookieList.getSetCookies()) != null) {
            int n = 0;
            while (n < httpSetCookieArray.length) {
                if (httpSetCookieArray[n].getDomain() == null) {
                    httpSetCookieArray[n].setDomain(request.getURL().getHost());
                }
                root.insertCookie(httpSetCookieArray[n++]);
            }
        }
        return reply;
    }

    public boolean exceptionFilter(Request request, HttpException httpException) {
        return false;
    }

    public void sync() {
        root.sync(cookiefile);
    }

    public void initialize(HttpManager httpManager) throws PropRequestFilterException {
        this.manager = httpManager;
        ObservableProperties observableProperties = httpManager.getProperties();
        String string = observableProperties.getString(COOKIES_FILE_P, null);
        cookiefile = string == null ? new File(defaultFileName) : new File(string);
        if (cookiefile.exists()) {
            try {
                root.loadCookies(cookiefile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException.getMessage());
                throw new PropRequestFilterException(fileNotFoundException.getMessage());
            }
        }
        httpManager.setFilter(this);
    }

    static {
        root = new DomainTree();
        cookiefile = null;
    }
}

