/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSMediaExpression;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CSSMediaQuery
implements ICSSWriteable {
    private final EModifier m_eModifier;
    private final String m_sMedium;
    private final List<CSSMediaExpression> m_aMediaExpressions = new ArrayList<CSSMediaExpression>();

    public CSSMediaQuery(@Nonnull EModifier eModifier, @Nullable String sMedium) {
        if (eModifier == null) {
            throw new NullPointerException("modifier");
        }
        this.m_eModifier = eModifier;
        this.m_sMedium = sMedium;
    }

    public boolean isNot() {
        return this.m_eModifier == EModifier.NOT;
    }

    public boolean isOnly() {
        return this.m_eModifier == EModifier.ONLY;
    }

    @Nullable
    public String getMedium() {
        return this.m_sMedium;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaExpression> getMediaExpressions() {
        return ContainerHelper.newList(this.m_aMediaExpressions);
    }

    public void addMediaExpression(@Nonnull CSSMediaExpression aMediaExpression) {
        if (aMediaExpression == null) {
            throw new NullPointerException("expression");
        }
        this.m_aMediaExpressions.add(aMediaExpression);
    }

    @Nonnull
    public EChange removeMediaExpression(@Nonnull CSSMediaExpression aMediaExpression) {
        return EChange.valueOf((boolean)this.m_aMediaExpressions.remove(aMediaExpression));
    }

    @Nonnull
    public EChange removeMediaExpression(@Nonnull int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_aMediaExpressions.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aMediaExpressions.remove(nIndex) != null ? 1 : 0) != 0);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder aSB = new StringBuilder();
        aSB.append(this.m_eModifier.getCSSText());
        boolean bIsFirstExpression = true;
        if (this.m_sMedium != null) {
            aSB.append(this.m_sMedium);
            bIsFirstExpression = false;
        }
        if (!this.m_aMediaExpressions.isEmpty()) {
            for (CSSMediaExpression aMediaExpression : this.m_aMediaExpressions) {
                if (bIsFirstExpression) {
                    bIsFirstExpression = false;
                } else {
                    aSB.append(" and ");
                }
                aSB.append(aMediaExpression.getAsCSSString(aSettings, nIndentLevel));
            }
        }
        return aSB.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSMediaQuery)) {
            return false;
        }
        CSSMediaQuery rhs = (CSSMediaQuery)o;
        return this.m_eModifier.equals((Object)rhs.m_eModifier) && EqualsUtils.equals((Object)this.m_sMedium, (Object)rhs.m_sMedium) && ((Object)this.m_aMediaExpressions).equals(rhs.m_aMediaExpressions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eModifier).append((Object)this.m_sMedium).append(this.m_aMediaExpressions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("modifier", (Enum)this.m_eModifier).append("medium", (Object)this.m_sMedium).append("expressions", this.m_aMediaExpressions).toString();
    }

    public static enum EModifier {
        NONE(""),
        NOT("not "),
        ONLY("only ");

        private final String m_sText;

        private EModifier(String sText) {
            this.m_sText = sText;
        }

        @Nonnull
        public String getCSSText() {
            return this.m_sText;
        }
    }
}

