/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSSelectorMemberNot
implements ICSSSelectorMember,
ICSSVersionAware {
    private final ICSSSelectorMember m_aNestedSelectorMember;

    public CSSSelectorMemberNot(@Nonnull @Nonempty ICSSSelectorMember aNestedSelectorMember) {
        if (aNestedSelectorMember == null) {
            throw new NullPointerException("nestedSelector");
        }
        this.m_aNestedSelectorMember = aNestedSelectorMember;
    }

    @Nonnull
    public ICSSSelectorMember getNestedMember() {
        return this.m_aNestedSelectorMember;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return ":not(" + this.m_aNestedSelectorMember.getAsCSSString(aSettings, nIndentLevel) + ")";
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSSelectorMemberNot)) {
            return false;
        }
        CSSSelectorMemberNot rhs = (CSSSelectorMemberNot)o;
        return this.m_aNestedSelectorMember.equals(rhs.m_aNestedSelectorMember);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aNestedSelectorMember).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("nestedSelector", (Object)this.m_aNestedSelectorMember).toString();
    }
}

