/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.name.IHasName;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSSelectorCombinator implements ICSSSelectorMember,
ICSSVersionAware,
IHasName
{
    PLUS("+"),
    GREATER(">"),
    TILDE("~", ECSSVersion.CSS30),
    BLANK(" ");

    private final String m_sName;
    private final ECSSVersion m_eVersion;

    private ECSSSelectorCombinator(String sName) {
        this(sName, ECSSVersion.CSS21);
    }

    private ECSSSelectorCombinator(String sName, ECSSVersion eVersion) {
        this.m_sName = sName;
        this.m_eVersion = eVersion;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return this.m_sName;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return this.m_eVersion;
    }

    @Nullable
    public static ECSSSelectorCombinator getFromNameOrNull(@Nullable String sName) {
        return (ECSSSelectorCombinator)EnumHelper.getFromNameOrNull(ECSSSelectorCombinator.class, (String)sName);
    }
}

