/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.AbstractCSSProperty;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.utils.CSSNumberHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSPropertyNumber
extends AbstractCSSProperty {
    private final boolean m_bWithPercentage;

    public CSSPropertyNumber(@Nonnull ECSSProperty eProp, boolean bWithPercentage) {
        super(eProp);
        this.m_bWithPercentage = bWithPercentage;
    }

    @Override
    public boolean isValidValue(@Nullable String sValue) {
        return CSSNumberHelper.isNumberWithUnitValue(sValue, this.m_bWithPercentage);
    }

    @Override
    @Nonnull
    public CSSPropertyNumber getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyNumber(eProp, this.m_bWithPercentage);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).toString();
    }
}

