/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.propertyvalue;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.propertyvalue.CSSValue;
import com.phloc.css.propertyvalue.ICSSMultiValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CSSValueList
implements ICSSMultiValue {
    private final List<CSSValue> m_aValues = new ArrayList<CSSValue>();

    public CSSValueList(@Nonnull ICSSProperty[] aProperties, @Nonnull String[] aValues, boolean bIsImportant) {
        if (ArrayHelper.isEmpty((Object[])aProperties)) {
            throw new IllegalArgumentException("No properties passed!");
        }
        if (ArrayHelper.isEmpty((Object[])aValues)) {
            throw new IllegalArgumentException("No value passed!");
        }
        if (aProperties.length != aValues.length) {
            throw new IllegalArgumentException("Different number of properties and values passed");
        }
        for (int i = 0; i < aProperties.length; ++i) {
            this.m_aValues.add(new CSSValue(aProperties[i], aValues[i], bIsImportant));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSValue> getContainedValues() {
        return ContainerHelper.newList(this.m_aValues);
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        if (this.m_aValues.isEmpty()) {
            throw new IllegalStateException("No value present to determine the property from!");
        }
        return ((CSSValue)ContainerHelper.getLastElement(this.m_aValues)).getProp();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder ret = new StringBuilder();
        for (CSSValue aValue : this.m_aValues) {
            ret.append(aValue.getAsCSSString(aSettings, nIndentLevel));
        }
        return ret.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSValueList)) {
            return false;
        }
        CSSValueList rhs = (CSSValueList)o;
        return ((Object)this.m_aValues).equals(rhs.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).toString();
    }
}

