/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.writer;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSWriterSettings
implements ICSSWriterSettings {
    public static final boolean DEFAULT_OPTIMIZED_OUTPUT = false;
    public static final boolean DEFAULT_REMOVE_UNNECESSARY_CODE = false;
    public static final String DEFAULT_INDENT = "  ";
    public static final boolean DEFAULT_QUOTE_URLS = false;
    public static final boolean DEFAULT_WRITE_FONT_FACE_RULES = true;
    public static final boolean DEFAULT_WRITE_KEYFRAMES_RULES = true;
    public static final boolean DEFAULT_WRITE_MEDIA_RULES = true;
    public static final boolean DEFAULT_WRITE_PAGE_RULES = true;
    private final ECSSVersion m_eVersion;
    private boolean m_bOptimizedOutput;
    private boolean m_bRemoveUnnecessaryCode = false;
    private String m_sIndent = "  ";
    private boolean m_bQuoteURLs = false;
    private boolean m_bWriteFontFaceRules = true;
    private boolean m_bWriteKeyframesRules = true;
    private boolean m_bWriteMediaRules = true;
    private boolean m_bWritePageRules = true;

    public CSSWriterSettings(@Nonnull ECSSVersion eVersion) {
        this(eVersion, false);
    }

    public CSSWriterSettings(@Nonnull ECSSVersion eVersion, boolean bOptimizedOutput) {
        if (eVersion == null) {
            throw new NullPointerException("version");
        }
        this.m_eVersion = eVersion;
        this.m_bOptimizedOutput = bOptimizedOutput;
    }

    public CSSWriterSettings(@Nonnull ICSSWriterSettings aBase) {
        if (aBase == null) {
            throw new NullPointerException("base");
        }
        this.m_eVersion = aBase.getVersion();
        this.m_bOptimizedOutput = aBase.isOptimizedOutput();
        this.m_sIndent = aBase.getIndent(1);
        this.m_bQuoteURLs = aBase.isQuoteURLs();
        this.m_bWriteFontFaceRules = aBase.isWriteFontFaceRules();
        this.m_bWriteKeyframesRules = aBase.isWriteKeyframesRules();
        this.m_bWriteMediaRules = aBase.isWriteMediaRules();
        this.m_bWritePageRules = aBase.isWritePageRules();
    }

    @Override
    @Nonnull
    public final ECSSVersion getVersion() {
        return this.m_eVersion;
    }

    @Override
    public final boolean isOptimizedOutput() {
        return this.m_bOptimizedOutput;
    }

    @Nonnull
    public final CSSWriterSettings setOptimizedOutput(boolean bOptimizedOutput) {
        this.m_bOptimizedOutput = bOptimizedOutput;
        return this;
    }

    @Override
    public final boolean isRemoveUnnecessaryCode() {
        return this.m_bRemoveUnnecessaryCode;
    }

    @Nonnull
    public final CSSWriterSettings setRemoveUnnecessaryCode(boolean bRemoveUnnecessaryCode) {
        this.m_bRemoveUnnecessaryCode = bRemoveUnnecessaryCode;
        return this;
    }

    @Override
    @Nonnull
    public final String getIndent(@Nonnegative int nCount) {
        return StringHelper.getRepeated((String)this.m_sIndent, (int)nCount);
    }

    @Nonnull
    public final CSSWriterSettings setIndent(@Nonnull String sIndent) {
        if (sIndent == null) {
            throw new NullPointerException("indent");
        }
        this.m_sIndent = sIndent;
        return this;
    }

    @Override
    public final boolean isQuoteURLs() {
        return this.m_bQuoteURLs;
    }

    @Nonnull
    public final CSSWriterSettings setQuoteURLs(boolean bQuoteURLs) {
        this.m_bQuoteURLs = bQuoteURLs;
        return this;
    }

    @Override
    public final boolean isWriteFontFaceRules() {
        return this.m_bWriteFontFaceRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteFontFaceRules(boolean bWriteFontFaceRules) {
        this.m_bWriteFontFaceRules = bWriteFontFaceRules;
        return this;
    }

    @Override
    public final boolean isWriteKeyframesRules() {
        return this.m_bWriteKeyframesRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteKeyframesRules(boolean bWriteKeyframesRules) {
        this.m_bWriteKeyframesRules = bWriteKeyframesRules;
        return this;
    }

    @Override
    public final boolean isWriteMediaRules() {
        return this.m_bWriteMediaRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteMediaRules(boolean bWriteMediaRules) {
        this.m_bWriteMediaRules = bWriteMediaRules;
        return this;
    }

    @Override
    public final boolean isWritePageRules() {
        return this.m_bWritePageRules;
    }

    @Nonnull
    public final CSSWriterSettings setWritePageRules(boolean bWritePageRules) {
        this.m_bWritePageRules = bWritePageRules;
        return this;
    }

    @Override
    public void checkVersionRequirements(@Nonnull ICSSVersionAware aCSSObject) {
        ECSSVersion eMinCSSVersion = aCSSObject.getMinimumCSSVersion();
        if (this.m_eVersion.compareTo(eMinCSSVersion) < 0) {
            throw new IllegalStateException("This object cannot be serialized to CSS version " + this.m_eVersion.getVersion().getAsString() + " but requires at least " + eMinCSSVersion.getVersion().getAsString());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSWriterSettings rhs = (CSSWriterSettings)o;
        return this.m_eVersion.equals((Object)rhs.m_eVersion) && this.m_bOptimizedOutput == rhs.m_bOptimizedOutput && this.m_bRemoveUnnecessaryCode == rhs.m_bRemoveUnnecessaryCode && this.m_sIndent.equals(rhs.m_sIndent) && this.m_bQuoteURLs == rhs.m_bQuoteURLs && this.m_bWriteFontFaceRules == rhs.m_bWriteFontFaceRules && this.m_bWriteKeyframesRules == rhs.m_bWriteKeyframesRules && this.m_bWriteMediaRules == rhs.m_bWriteMediaRules && this.m_bWritePageRules == rhs.m_bWritePageRules;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eVersion).append(this.m_bOptimizedOutput).append(this.m_bRemoveUnnecessaryCode).append((Object)this.m_sIndent).append(this.m_bQuoteURLs).append(this.m_bWriteFontFaceRules).append(this.m_bWriteKeyframesRules).append(this.m_bWriteMediaRules).append(this.m_bWritePageRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("version", (Enum)this.m_eVersion).append("optimizedOutput", this.m_bOptimizedOutput).append("removeUnnecessaryCode", this.m_bRemoveUnnecessaryCode).append("indent", (Object)this.m_sIndent).append("quoteURLs", this.m_bQuoteURLs).append("writeFontFaceRules", this.m_bWriteFontFaceRules).append("writeKeyframesRules", this.m_bWriteKeyframesRules).append("writeMediaRules", this.m_bWriteMediaRules).append("writePageRules", this.m_bWritePageRules).toString();
    }
}

