/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.w3c.www.http.HTTP;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpAccept;
import org.w3c.www.http.HttpAcceptCharset;
import org.w3c.www.http.HttpAcceptCharsetList;
import org.w3c.www.http.HttpAcceptEncoding;
import org.w3c.www.http.HttpAcceptEncodingList;
import org.w3c.www.http.HttpAcceptLanguage;
import org.w3c.www.http.HttpAcceptList;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpCacheControl;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpDate;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpEntityTagList;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpInteger;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpRange;
import org.w3c.www.http.HttpRangeList;
import org.w3c.www.http.HttpString;
import org.w3c.www.http.ParseState;
import org.w3c.www.mime.MimeParser;

public class HttpRequestMessage
extends HttpEntityMessage {
    public static int H_ACCEPT = 31;
    public static int H_ACCEPT_CHARSET = 32;
    public static int H_ACCEPT_ENCODING = 33;
    public static int H_ACCEPT_LANGUAGE = 34;
    public static int H_AUTHORIZATION = 35;
    public static int H_EXPECT = 36;
    public static int H_FROM = 37;
    public static int H_HOST = 38;
    public static int H_IF_MODIFIED_SINCE = 39;
    public static int H_IF_MATCH = 40;
    public static int H_IF_NONE_MATCH = 41;
    public static int H_IF_RANGE = 42;
    public static int H_IF_UNMODIFIED_SINCE = 43;
    public static int H_MAX_FORWARDS = 44;
    public static int H_PROXY_AUTHORIZATION = 45;
    public static int H_RANGE = 46;
    public static int H_REFERER = 47;
    public static int H_TE = 48;
    public static int H_USER_AGENT = 49;
    protected String method = "GET".intern();
    protected URL url = null;
    protected URL proxy = null;
    protected String sProxy = null;
    String target = null;

    protected void startEmit(OutputStream outputStream, int n) throws IOException {
        Object object;
        if ((n & 1) != 1) {
            return;
        }
        if (this.major >= 1 && !this.hasHeader(H_HOST)) {
            object = this.url.getPort() == 80 && this.url.getProtocol().equalsIgnoreCase("http") || this.url.getPort() == 443 && this.url.getProtocol().equalsIgnoreCase("https") || this.url.getPort() == -1 ? this.url.getHost() : this.url.getHost() + ":" + this.url.getPort();
            this.setHeaderValue(H_HOST, (HeaderValue)HttpFactory.makeString((String)object));
        }
        object = new HttpBuffer();
        ((HttpBuffer)object).append(this.method);
        ((HttpBuffer)object).append(' ');
        if (this.proxy != null) {
            ((HttpBuffer)object).append(this.url.toExternalForm());
        } else {
            String string = this.url.getFile();
            if (string.length() == 0) {
                if (this.method == HTTP.OPTIONS) {
                    ((HttpBuffer)object).append('*');
                } else {
                    ((HttpBuffer)object).append('/');
                }
            } else {
                ((HttpBuffer)object).append(string);
            }
        }
        ((HttpBuffer)object).append(' ');
        ((HttpBuffer)object).append(this.getVersion());
        ((HttpBuffer)object).append('\r');
        ((HttpBuffer)object).append('\n');
        ((HttpBuffer)object).emit(outputStream);
    }

    public void dump(OutputStream outputStream) {
        try {
            this.startEmit(outputStream, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dump(outputStream);
    }

    public boolean notifyBeginParsing(MimeParser mimeParser) throws HttpParserException, IOException {
        HttpBuffer httpBuffer = new HttpBuffer();
        int n = mimeParser.read();
        while (n == 13 || n == 10) {
            n = mimeParser.read();
        }
        block6: while (true) {
            switch (n) {
                case -1: {
                    throw new HttpParserException("End Of File");
                }
                case 13: {
                    n = mimeParser.read();
                    if (n == 10) break block6;
                    mimeParser.unread(n);
                    break block6;
                }
                case 10: {
                    break block6;
                }
                default: {
                    httpBuffer.append(n);
                    n = mimeParser.read();
                    continue block6;
                }
            }
            break;
        }
        byte[] byArray = httpBuffer.getByteCopy();
        ParseState parseState = new ParseState();
        parseState.ioff = 0;
        parseState.bufend = byArray.length;
        parseState.separator = (byte)32;
        if (HttpParser.nextItem(byArray, parseState) < 0) {
            throw new RuntimeException("Bad request, no method !");
        }
        this.setMethod(parseState.toString(byArray));
        if (HttpParser.nextItem(byArray, parseState) < 0) {
            throw new RuntimeException("Bad request, no URL !");
        }
        this.setTarget(parseState.toString(byArray));
        HttpParser.skipSpaces(byArray, parseState);
        if (parseState.ioff + 5 < parseState.bufend) {
            parseState.ioff += 5;
            parseState.separator = (byte)46;
            this.major = (short)HttpParser.parseInt(byArray, parseState);
            parseState.prepare();
            this.minor = (short)HttpParser.parseInt(byArray, parseState);
            return false;
        }
        this.major = 0;
        this.minor = (short)9;
        return true;
    }

    public void notifyEndParsing(MimeParser mimeParser) throws HttpParserException, IOException {
        if (this.major == 1 && this.minor == 1 && this.getHost() == null) {
            throw new HttpParserException("missing Host header", this);
        }
    }

    protected void setTarget(String string) {
        this.target = string;
    }

    protected String getTarget() {
        return this.target;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string.intern();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public int getMinFresh() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? -1 : httpCacheControl.getMinFresh();
    }

    public void setMinFresh(int n) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (n == -1) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setMinFresh(n);
    }

    public int getMaxStale() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? -1 : httpCacheControl.getMaxStale();
    }

    public void setMaxStale(int n) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (n == -1) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setMaxStale(n);
    }

    public HttpAccept[] getAccept() {
        HeaderValue headerValue = this.getHeaderValue(H_ACCEPT);
        return headerValue != null ? (HttpAccept[])headerValue.getValue() : null;
    }

    public void setAccept(HttpAccept[] httpAcceptArray) {
        this.setHeaderValue(H_ACCEPT, (HeaderValue)(httpAcceptArray == null ? null : new HttpAcceptList(httpAcceptArray)));
    }

    public HttpAcceptCharset[] getAcceptCharset() {
        HeaderValue headerValue = this.getHeaderValue(H_ACCEPT_CHARSET);
        return headerValue != null ? (HttpAcceptCharset[])headerValue.getValue() : null;
    }

    public void setAcceptCharset(HttpAcceptCharset[] httpAcceptCharsetArray) {
        this.setHeaderValue(H_ACCEPT_CHARSET, (HeaderValue)(httpAcceptCharsetArray == null ? null : new HttpAcceptCharsetList(httpAcceptCharsetArray)));
    }

    public HttpAcceptEncoding[] getAcceptEncoding() {
        HeaderValue headerValue = this.getHeaderValue(H_ACCEPT_ENCODING);
        return headerValue != null ? (HttpAcceptEncoding[])headerValue.getValue() : null;
    }

    public void setAcceptEncoding(HttpAcceptEncoding[] httpAcceptEncodingArray) {
        this.setHeaderValue(H_ACCEPT_ENCODING, (HeaderValue)(httpAcceptEncodingArray == null ? null : new HttpAcceptEncodingList(httpAcceptEncodingArray)));
    }

    public HttpAcceptLanguage[] getAcceptLanguage() {
        HeaderValue headerValue = this.getHeaderValue(H_ACCEPT_LANGUAGE);
        return headerValue != null ? (HttpAcceptLanguage[])headerValue.getValue() : null;
    }

    public void setAcceptLanguage(HttpAcceptCharset[] httpAcceptCharsetArray) {
        this.setHeaderValue(H_ACCEPT_LANGUAGE, (HeaderValue)(httpAcceptCharsetArray == null ? null : new HttpAcceptCharsetList(httpAcceptCharsetArray)));
    }

    public HttpCredential getAuthorization() {
        HeaderValue headerValue = this.getHeaderValue(H_AUTHORIZATION);
        return headerValue != null ? (HttpCredential)headerValue.getValue() : null;
    }

    public void setAuthorization(HttpCredential httpCredential) {
        this.setHeaderValue(H_AUTHORIZATION, (HeaderValue)httpCredential);
    }

    public boolean hasAuthorization() {
        return this.hasHeader(H_AUTHORIZATION);
    }

    public String getFrom() {
        HeaderValue headerValue = this.getHeaderValue(H_FROM);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public void setFrom(String string) {
        this.setHeaderValue(H_FROM, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public String getHost() {
        HeaderValue headerValue = this.getHeaderValue(H_HOST);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public void setHost(String string) {
        this.setHeaderValue(H_HOST, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public long getIfModifiedSince() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_MODIFIED_SINCE);
        return headerValue != null ? (Long)headerValue.getValue() : -1L;
    }

    public void setIfModifiedSince(long l) {
        this.setHeaderValue(H_IF_MODIFIED_SINCE, (HeaderValue)(l == -1L ? null : new HttpDate(true, l)));
    }

    public HttpEntityTag[] getIfMatch() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_MATCH);
        return headerValue != null ? (HttpEntityTag[])headerValue.getValue() : null;
    }

    public void setIfMatch(HttpEntityTag[] httpEntityTagArray) {
        this.setHeaderValue(H_IF_MATCH, (HeaderValue)(httpEntityTagArray != null ? new HttpEntityTagList(httpEntityTagArray) : null));
    }

    public HttpEntityTag[] getIfNoneMatch() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_NONE_MATCH);
        return headerValue != null ? (HttpEntityTag[])headerValue.getValue() : null;
    }

    public void setIfNoneMatch(HttpEntityTag[] httpEntityTagArray) {
        this.setHeaderValue(H_IF_NONE_MATCH, (HeaderValue)(httpEntityTagArray == null ? null : new HttpEntityTagList(httpEntityTagArray)));
    }

    public HttpEntityTag getIfRange() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_RANGE);
        return headerValue != null ? (HttpEntityTag)headerValue : null;
    }

    public void setIfRange(HttpEntityTag httpEntityTag) {
        this.setHeaderValue(H_IF_RANGE, (HeaderValue)httpEntityTag);
    }

    public long getIfUnmodifiedSince() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_UNMODIFIED_SINCE);
        return headerValue != null ? (Long)headerValue.getValue() : -1L;
    }

    public void setIfUnmodifiedSince(long l) {
        if (l == -1L) {
            this.setHeaderValue(H_IF_UNMODIFIED_SINCE, null);
        } else {
            this.setHeaderValue(H_IF_UNMODIFIED_SINCE, (HeaderValue)new HttpDate(true, l));
        }
    }

    public int getMaxForwards() {
        HeaderValue headerValue = this.getHeaderValue(H_MAX_FORWARDS);
        return headerValue != null ? (Integer)headerValue.getValue() : -1;
    }

    public void setMaxForwards(int n) {
        if (n == -1) {
            this.setHeaderValue(H_MAX_FORWARDS, null);
        } else {
            this.setHeaderValue(H_MAX_FORWARDS, (HeaderValue)new HttpInteger(true, n));
        }
    }

    public void setProxyAuthorization(HttpCredential httpCredential) {
        this.setHeaderValue(H_PROXY_AUTHORIZATION, (HeaderValue)httpCredential);
    }

    public HttpCredential getProxyAuthorization() {
        HeaderValue headerValue = this.getHeaderValue(H_PROXY_AUTHORIZATION);
        return headerValue != null ? (HttpCredential)headerValue.getValue() : null;
    }

    public HttpRange[] getRange() {
        HeaderValue headerValue = this.getHeaderValue(H_RANGE);
        return headerValue != null ? (HttpRange[])headerValue.getValue() : null;
    }

    public void setRange(HttpRange[] httpRangeArray) {
        this.setHeaderValue(H_RANGE, (HeaderValue)(httpRangeArray == null ? null : new HttpRangeList(httpRangeArray)));
    }

    public String getReferer() {
        HeaderValue headerValue = this.getHeaderValue(H_REFERER);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public void setReferer(String string) {
        this.setHeaderValue(H_REFERER, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public String getUserAgent() {
        HeaderValue headerValue = this.getHeaderValue(H_USER_AGENT);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public void setUserAgent(String string) {
        this.setHeaderValue(H_USER_AGENT, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public String getExpect() {
        HeaderValue headerValue = this.getHeaderValue(H_EXPECT);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public void setExpect(String string) {
        this.setHeaderValue(H_EXPECT, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public HttpAcceptEncoding[] getTE() {
        HeaderValue headerValue = this.getHeaderValue(H_TE);
        return headerValue != null ? (HttpAcceptEncoding[])headerValue.getValue() : null;
    }

    public void setTE(HttpAcceptEncoding[] httpAcceptEncodingArray) {
        this.setHeaderValue(H_TE, (HeaderValue)(httpAcceptEncodingArray == null ? null : new HttpAcceptEncodingList(httpAcceptEncodingArray)));
    }

    public void setProxy(URL uRL) {
        this.proxy = uRL;
        this.sProxy = uRL == null ? null : uRL.toExternalForm();
    }

    public URL getProxy() {
        return this.proxy;
    }

    public boolean hasProxy() {
        return this.proxy != null;
    }

    public HttpRequestMessage(MimeParser mimeParser) {
        super(mimeParser);
    }

    public HttpRequestMessage() {
    }

    public static void main(String[] stringArray) {
        try {
            HttpRequestMessage httpRequestMessage = new HttpRequestMessage();
            httpRequestMessage.setURL(new URL("http://www.w3.org/"));
            httpRequestMessage.setHost("http://www.w3.org");
            httpRequestMessage.setFrom("abaird@w3.org");
            httpRequestMessage.setReferer("http://abaird.w3.org/");
            HttpCacheControl httpCacheControl = new HttpCacheControl(true);
            httpCacheControl.setMaxAge(10);
            httpCacheControl.setNoStore(true);
            httpRequestMessage.setCacheControl(httpCacheControl);
            httpRequestMessage.emit(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        HttpRequestMessage.registerHeader("Accept", "org.w3c.www.http.HttpAcceptList", H_ACCEPT);
        HttpRequestMessage.registerHeader("Accept-Charset", "org.w3c.www.http.HttpAcceptCharsetList", H_ACCEPT_CHARSET);
        HttpRequestMessage.registerHeader("Accept-Encoding", "org.w3c.www.http.HttpAcceptEncodingList", H_ACCEPT_ENCODING);
        HttpRequestMessage.registerHeader("Accept-Language", "org.w3c.www.http.HttpAcceptLanguageList", H_ACCEPT_LANGUAGE);
        HttpRequestMessage.registerHeader("Authorization", "org.w3c.www.http.HttpCredential", H_AUTHORIZATION);
        HttpRequestMessage.registerHeader("From", "org.w3c.www.http.HttpString", H_FROM);
        HttpRequestMessage.registerHeader("Host", "org.w3c.www.http.HttpString", H_HOST);
        HttpRequestMessage.registerHeader("If-Modified-Since", "org.w3c.www.http.HttpDate", H_IF_MODIFIED_SINCE);
        HttpRequestMessage.registerHeader("If-Match", "org.w3c.www.http.HttpEntityTagList", H_IF_MATCH);
        HttpRequestMessage.registerHeader("If-None-Match", "org.w3c.www.http.HttpEntityTagList", H_IF_NONE_MATCH);
        HttpRequestMessage.registerHeader("If-Range", "org.w3c.www.http.HttpEntityTag", H_IF_RANGE);
        HttpRequestMessage.registerHeader("If-Unmodified-Since", "org.w3c.www.http.HttpDate", H_IF_UNMODIFIED_SINCE);
        HttpRequestMessage.registerHeader("Max-Forwards", "org.w3c.www.http.HttpInteger", H_MAX_FORWARDS);
        HttpRequestMessage.registerHeader("Proxy-Authorization", "org.w3c.www.http.HttpCredential", H_PROXY_AUTHORIZATION);
        HttpRequestMessage.registerHeader("Range", "org.w3c.www.http.HttpRangeList", H_RANGE);
        HttpRequestMessage.registerHeader("Referer", "org.w3c.www.http.HttpString", H_REFERER);
        HttpRequestMessage.registerHeader("User-Agent", "org.w3c.www.http.HttpString", H_USER_AGENT);
        HttpRequestMessage.registerHeader("Expect", "org.w3c.www.http.HttpString", H_EXPECT);
        HttpRequestMessage.registerHeader("TE", "org.w3c.www.http.HttpAcceptEncodingList", H_TE);
    }
}

