/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ArrayIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    private ELEMENTTYPE[] m_aArray;
    private int m_nIndex;

    public ArrayIterator(ELEMENTTYPE ... aArray) {
        this(aArray, 0, aArray.length);
    }

    public ArrayIterator(@Nonnull ELEMENTTYPE[] aArray, @Nonnegative int nBegin, @Nonnegative int nEnd) {
        if (aArray == null) {
            throw new NullPointerException("array");
        }
        if (nBegin < 0 || nEnd < nBegin) {
            throw new IllegalArgumentException("Begin (" + nBegin + ") must be between 0 and < end (" + nEnd + ")");
        }
        this.m_nIndex = 0;
        int nLength = nEnd - nBegin;
        this.m_aArray = ArrayHelper.getCopy(aArray, nBegin, nLength);
    }

    @Override
    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayIterator)) {
            return false;
        }
        ArrayIterator rhs = (ArrayIterator)o;
        return EqualsUtils.equals(this.m_aArray, rhs.m_aArray) && this.m_nIndex == rhs.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> ArrayIterator<ELEMENTTYPE> create(@Nonnull ELEMENTTYPE[] aArray) {
        return new ArrayIterator<ELEMENTTYPE>(aArray);
    }
}

