/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.iterate;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.filter.collections.FilterIterator;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.filter.FileFilterToIFilterAdapter;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemRecursiveIterator
implements IIterableIterator<File> {
    private final int m_nStartLevel;
    private int m_nLevel = 0;
    private final IFilter<File> m_aRecursionFilter;
    private final List<File> m_aFilesLeft;

    @Nonnegative
    private static int _getLevel(@Nonnull File aFile) {
        return StringHelper.getCharCount(aFile.getAbsolutePath(), File.separatorChar);
    }

    public FileSystemRecursiveIterator(@Nonnull String sBaseDir) {
        this(new File(sBaseDir), null);
    }

    public FileSystemRecursiveIterator(@Nonnull File aBaseDir) {
        this(aBaseDir, null);
    }

    public FileSystemRecursiveIterator(@Nonnull String sBaseDir, @Nullable IFilter<File> aRecursionFilter) {
        this(new File(sBaseDir), aRecursionFilter);
    }

    public FileSystemRecursiveIterator(@Nonnull File aBaseDir, @Nullable IFilter<File> aRecursionFilter) {
        if (aBaseDir == null) {
            throw new NullPointerException("directory");
        }
        this.m_nStartLevel = FileSystemRecursiveIterator._getLevel(aBaseDir);
        this.m_aRecursionFilter = aRecursionFilter;
        this.m_aFilesLeft = FileUtils.getDirectoryContent(aBaseDir);
    }

    @Override
    @Nonnull
    public final Iterator<File> iterator() {
        return this;
    }

    @Override
    public final boolean hasNext() {
        return !this.m_aFilesLeft.isEmpty();
    }

    @OverrideOnDemand
    protected boolean recurseIntoDirectory(@Nonnull File aDirectory) {
        return this.m_aRecursionFilter == null || this.m_aRecursionFilter.matchesFilter(aDirectory);
    }

    @Override
    @Nonnull
    public final File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        File aFile = this.m_aFilesLeft.remove(0);
        this.m_nLevel = FileSystemRecursiveIterator._getLevel(aFile) - this.m_nStartLevel;
        if (aFile.isDirectory() && this.recurseIntoDirectory(aFile)) {
            this.m_aFilesLeft.addAll(0, FileUtils.getDirectoryContent(aFile));
        }
        return aFile;
    }

    @Nonnegative
    public final int getLevel() {
        return this.m_nLevel;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new ToStringGenerator(this).append("files", this.m_aFilesLeft).toString();
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String sBaseDir, @Nonnull FilenameFilter aFilenameFilter) {
        return FileSystemRecursiveIterator.create(new File(sBaseDir), aFilenameFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File fBaseDir, @Nonnull FilenameFilter aFilenameFilter) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(fBaseDir), (IFilter<File>)new FileFilterToIFilterAdapter(aFilenameFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String sBaseDir, FilenameFilter ... aFilenameFilters) {
        return FileSystemRecursiveIterator.create(new File(sBaseDir), aFilenameFilters);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File fBaseDir, FilenameFilter ... aFilenameFilters) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(fBaseDir), FileFilterToIFilterAdapter.getANDChained(aFilenameFilters));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String sBaseDir, @Nonnull FileFilter aFileFilter) {
        return FileSystemRecursiveIterator.create(new File(sBaseDir), aFileFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File fBaseDir, @Nonnull FileFilter aFileFilter) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(fBaseDir), (IFilter<File>)new FileFilterToIFilterAdapter(aFileFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String sBaseDir, FileFilter ... aFileFilters) {
        return FileSystemRecursiveIterator.create(new File(sBaseDir), aFileFilters);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File fBaseDir, FileFilter ... aFileFilters) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(fBaseDir), FileFilterToIFilterAdapter.getANDChained(aFileFilters));
    }
}

