/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.io.streams.StreamUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class BitInputStream
implements Closeable {
    private final Lock m_aLock = new ReentrantLock();
    private InputStream m_aIS;
    private int m_nBuffer;
    private int m_nNextBitIndex;
    private final boolean m_bHighOrderBitFirst;

    public BitInputStream(@Nonnull InputStream aIS, boolean bHighOrderBitFirst) {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        this.m_aIS = new BufferedInputStream(aIS);
        this.m_nNextBitIndex = 8;
        this.m_bHighOrderBitFirst = bHighOrderBitFirst;
    }

    public int readBits(@Nonnegative int aNumberOfBits) throws IOException {
        if (aNumberOfBits < 1 || aNumberOfBits > 32) {
            throw new IllegalArgumentException("Illegal number of bits passed!");
        }
        int ret = 0;
        for (int i = aNumberOfBits - 1; i >= 0; --i) {
            ret |= this.readBit() << i;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBit() throws IOException {
        this.m_aLock.lock();
        try {
            if (this.m_aIS == null) {
                throw new IOException("Already closed");
            }
            if (this.m_nNextBitIndex == 8) {
                this.m_nBuffer = this.m_aIS.read();
                if (this.m_nBuffer == -1) {
                    throw new EOFException();
                }
                this.m_nNextBitIndex = 0;
            }
            int nSelectorBit = this.m_bHighOrderBitFirst ? 1 << 7 - this.m_nNextBitIndex : 1 << this.m_nNextBitIndex;
            int nBitValue = this.m_nBuffer & nSelectorBit;
            ++this.m_nNextBitIndex;
            int n = nBitValue == 0 ? 0 : 1;
            return n;
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_aLock.lock();
        try {
            StreamUtils.close(this.m_aIS);
            this.m_aIS = null;
        }
        finally {
            this.m_aLock.unlock();
        }
    }
}

