/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.io.streams.WrappedOutputStream;
import com.phloc.commons.messagedigest.EMessageDigestAlgorithm;
import com.phloc.commons.messagedigest.IMessageDigestGenerator;
import com.phloc.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class HashingOutputStream
extends WrappedOutputStream {
    private final IMessageDigestGenerator m_aMDGen;

    public HashingOutputStream(@Nonnull OutputStream aSourceOS, @Nonnull EMessageDigestAlgorithm eMDAlgorithm) {
        super(aSourceOS);
        this.m_aMDGen = new NonBlockingMessageDigestGenerator(eMDAlgorithm);
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        this.m_aMDGen.update((byte)n);
    }

    @Override
    public void write(byte[] aBuf, int nOfs, int nLength) throws IOException {
        super.write(aBuf, nOfs, nLength);
        this.m_aMDGen.update(aBuf, nOfs, nLength);
    }

    @Nonnull
    public byte[] getDigest() {
        return this.m_aMDGen.getDigest();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("mdgen", this.m_aMDGen).toString();
    }
}

