/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.utils;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.parent.IChildrenProvider;
import com.phloc.commons.string.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ChildrenProviderElementWithName
implements IChildrenProvider<IMicroElement> {
    private final String m_sNamespaceURI;
    private final String m_sTagName;

    public ChildrenProviderElementWithName(@Nonnull @Nonempty String sTagName) {
        this(null, sTagName);
    }

    public ChildrenProviderElementWithName(@Nullable String sNamespaceURI, @Nonnull @Nonempty String sTagName) {
        if (StringHelper.hasNoText(sTagName)) {
            throw new IllegalArgumentException("tagName");
        }
        this.m_sNamespaceURI = sNamespaceURI;
        this.m_sTagName = sTagName;
    }

    @Override
    public boolean hasChildren(@Nullable IMicroElement aCurrent) {
        if (aCurrent == null || !aCurrent.isElement()) {
            return false;
        }
        if (StringHelper.hasText(this.m_sNamespaceURI)) {
            return aCurrent.hasChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return aCurrent.hasChildElements(this.m_sTagName);
    }

    @Override
    @Nonnegative
    public int getChildCount(@Nullable IMicroElement aCurrent) {
        return aCurrent == null ? 0 : this.getChildren(aCurrent).size();
    }

    @Override
    @Nonnull
    public Collection<? extends IMicroElement> getChildren(@Nullable IMicroElement aCurrent) {
        if (aCurrent == null) {
            return new ArrayList();
        }
        if (StringHelper.hasText(this.m_sNamespaceURI)) {
            return aCurrent.getChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return aCurrent.getChildElements(this.m_sTagName);
    }
}

