/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.version;

import com.phloc.commons.IHasStringRepresentation;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Version
implements Comparable<Version>,
IHasStringRepresentation,
Serializable {
    public static final String DEFAULT_VERSION_STRING = "0";
    public static final boolean DEFAULT_PRINT_ZERO_ELEMENTS = false;
    private final int m_nMajor;
    private final int m_nMinor;
    private final int m_nMicro;
    private final String m_sQualifier;

    public Version(@Nonnegative int nMajor) {
        this(nMajor, 0, 0, null);
    }

    public Version(@Nonnegative int nMajor, @Nonnegative int nMinor) {
        this(nMajor, nMinor, 0, null);
    }

    public Version(@Nonnegative int nMajor, @Nonnegative int nMinor, @Nonnegative int nMicro) {
        this(nMajor, nMinor, nMicro, null);
    }

    public Version(@Nonnegative int nMajor, @Nonnegative int nMinor, @Nonnegative int nMicro, @Nonnegative int nQualifier) {
        this(nMajor, nMinor, nMicro, Integer.toString(nQualifier));
    }

    public Version(@Nonnegative int nMajor, @Nonnegative int nMinor, @Nonnegative int nMicro, @Nullable String sQualifier) {
        this.m_nMajor = nMajor;
        this.m_nMinor = nMinor;
        this.m_nMicro = nMicro;
        String string = this.m_sQualifier = StringHelper.hasNoText(sQualifier) ? null : sQualifier;
        if (this.m_nMajor < 0) {
            throw new IllegalArgumentException("Major version " + this.m_nMajor + " is < 0");
        }
        if (this.m_nMinor < 0) {
            throw new IllegalArgumentException("Minor version " + this.m_nMinor + " is < 0");
        }
        if (this.m_nMicro < 0) {
            throw new IllegalArgumentException("Micro version " + this.m_nMicro + " is < 0");
        }
    }

    public Version(@Nullable String sVersionString) {
        this(sVersionString, true);
    }

    @Nonnull
    private static String[] _extSplit(String s) {
        String[] aDotParts = StringHelper.getExplodedArray('.', s, 2);
        if (aDotParts.length == 2) {
            return aDotParts;
        }
        if (StringParser.isInt(aDotParts[0])) {
            return aDotParts;
        }
        String[] aDashParts = StringHelper.getExplodedArray('-', s, 2);
        if (aDashParts.length == 1) {
            return aDotParts;
        }
        return aDashParts;
    }

    public Version(@Nullable String sVersionString, boolean bOldVersion) {
        String s;
        String string = s = sVersionString == null ? "" : sVersionString.trim();
        if (s.length() == 0) {
            s = DEFAULT_VERSION_STRING;
        }
        if (bOldVersion) {
            String[] aParts = StringHelper.getExplodedArray('.', s, 4);
            this.m_nMajor = aParts.length > 0 ? StringParser.parseInt(aParts[0], 0) : 0;
            this.m_nMinor = aParts.length > 1 ? StringParser.parseInt(aParts[1], 0) : 0;
            this.m_nMicro = aParts.length > 2 ? StringParser.parseInt(aParts[2], 0) : 0;
            this.m_sQualifier = aParts.length > 3 ? (StringHelper.hasNoText(aParts[3]) ? null : aParts[3]) : null;
        } else {
            String sRest;
            Integer aMajor = null;
            Integer aMinor = null;
            Integer aMicro = null;
            String sQualifier = null;
            boolean bDone = false;
            String[] aParts = Version._extSplit(s);
            aMajor = StringParser.parseIntObj(aParts[0]);
            if (aMajor == null && StringHelper.hasText(aParts[0])) {
                sQualifier = s;
                bDone = true;
            }
            String string2 = sRest = !bDone && aParts.length > 1 ? aParts[1] : null;
            if (sRest != null) {
                aParts = Version._extSplit(sRest);
                aMinor = StringParser.parseIntObj(aParts[0]);
                if (aMinor == null && StringHelper.hasText(aParts[0])) {
                    sQualifier = sRest;
                    bDone = true;
                }
                String string3 = sRest = !bDone && aParts.length > 1 ? aParts[1] : null;
                if (sRest != null) {
                    aParts = Version._extSplit(sRest);
                    aMicro = StringParser.parseIntObj(aParts[0]);
                    if (aMicro == null && StringHelper.hasText(aParts[0])) {
                        sQualifier = sRest;
                        bDone = true;
                    }
                    if (!bDone && aParts.length > 1) {
                        sQualifier = aParts[1];
                    }
                }
            }
            this.m_nMajor = aMajor == null ? 0 : aMajor;
            this.m_nMinor = aMinor == null ? 0 : aMinor;
            this.m_nMicro = aMicro == null ? 0 : aMicro;
            String string4 = this.m_sQualifier = StringHelper.hasNoText(sQualifier) ? null : sQualifier;
        }
        if (this.m_nMajor < 0) {
            throw new IllegalArgumentException("Major version " + this.m_nMajor + " is < 0");
        }
        if (this.m_nMinor < 0) {
            throw new IllegalArgumentException("Minor version " + this.m_nMinor + " is < 0");
        }
        if (this.m_nMicro < 0) {
            throw new IllegalArgumentException("Micro version " + this.m_nMicro + " is < 0");
        }
    }

    @Nonnegative
    public int getMajor() {
        return this.m_nMajor;
    }

    @Nonnegative
    public int getMinor() {
        return this.m_nMinor;
    }

    @Nonnegative
    public int getMicro() {
        return this.m_nMicro;
    }

    @Nullable
    public String getQualifier() {
        return this.m_sQualifier;
    }

    @Override
    public int compareTo(@Nonnull Version rhs) {
        if (rhs == null) {
            throw new NullPointerException("Cannot compare to null");
        }
        int ret = this.m_nMajor - rhs.m_nMajor;
        if (ret == 0 && (ret = this.m_nMinor - rhs.m_nMinor) == 0 && (ret = this.m_nMicro - rhs.m_nMicro) == 0) {
            if (this.m_sQualifier != null) {
                if (rhs.m_sQualifier != null) {
                    ret = this.m_sQualifier.compareTo(rhs.m_sQualifier);
                    if (ret < 0) {
                        ret = -1;
                    } else if (ret > 0) {
                        ret = 1;
                    }
                } else {
                    ret = 1;
                }
            } else {
                ret = rhs.m_sQualifier != null ? -1 : 0;
            }
        }
        return ret;
    }

    public boolean isGreaterThan(@Nonnull Version aVersion) {
        return this.compareTo(aVersion) > 0;
    }

    public boolean isGreaterOrEqualThan(@Nonnull Version aVersion) {
        return this.compareTo(aVersion) >= 0;
    }

    public boolean isLowerThan(@Nonnull Version aVersion) {
        return this.compareTo(aVersion) < 0;
    }

    public boolean isLowerOrEqualThan(@Nonnull Version aVersion) {
        return this.compareTo(aVersion) <= 0;
    }

    @Override
    @Nonnull
    public String getAsString() {
        return this.getAsString(false);
    }

    @Nonnull
    public String getAsString(boolean bPrintZeroElements) {
        StringBuilder aSB = new StringBuilder(this.m_sQualifier != null ? this.m_sQualifier : "");
        if (this.m_nMicro > 0 || aSB.length() > 0 || bPrintZeroElements) {
            if (aSB.length() > 0) {
                aSB.insert(0, '.');
            }
            aSB.insert(0, this.m_nMicro);
        }
        if (this.m_nMinor > 0 || aSB.length() > 0 || bPrintZeroElements) {
            if (aSB.length() > 0) {
                aSB.insert(0, '.');
            }
            aSB.insert(0, this.m_nMinor);
        }
        if (this.m_nMajor > 0 || aSB.length() > 0 || bPrintZeroElements) {
            if (aSB.length() > 0) {
                aSB.insert(0, '.');
            }
            aSB.insert(0, this.m_nMajor);
        }
        return aSB.length() > 0 ? aSB.toString() : DEFAULT_VERSION_STRING;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version rhs = (Version)o;
        return this.m_nMajor == rhs.m_nMajor && this.m_nMinor == rhs.m_nMinor && this.m_nMicro == rhs.m_nMicro && EqualsUtils.equals(this.m_sQualifier, rhs.m_sQualifier);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMajor).append(this.m_nMinor).append(this.m_nMicro).append(this.m_sQualifier).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("major", this.m_nMajor).append("minor", this.m_nMinor).append("micro", this.m_nMicro).appendIfNotNull("qualifier", this.m_sQualifier).toString();
    }
}

