/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.parse;

import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.input.parse.CommentListImpl;
import com.thaiopensource.relaxng.input.parse.ElementAnnotationBuilderImpl;
import com.thaiopensource.relaxng.input.parse.NamespaceContextImpl;
import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.Context;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsImpl
implements Annotations<SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl> {
    private CommentListImpl comments;
    private final List<AttributeAnnotation> attributes = new Vector<AttributeAnnotation>();
    private final List<AnnotationChild> elements = new Vector<AnnotationChild>();
    private final Context context;

    AnnotationsImpl(CommentListImpl commentListImpl, Context context) {
        this.comments = commentListImpl;
        this.context = context;
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, SourceLocation sourceLocation) throws BuildException {
        AttributeAnnotation attributeAnnotation = new AttributeAnnotation(string, string2, string4);
        attributeAnnotation.setPrefix(string3);
        attributeAnnotation.setSourceLocation(sourceLocation);
        this.attributes.add(attributeAnnotation);
    }

    @Override
    public void addElement(ElementAnnotationBuilderImpl elementAnnotationBuilderImpl) throws BuildException {
        elementAnnotationBuilderImpl.addTo(this.elements);
    }

    @Override
    public void addComment(CommentListImpl commentListImpl) throws BuildException {
        if (commentListImpl != null) {
            this.elements.addAll(commentListImpl.list);
        }
    }

    @Override
    public void addLeadingComment(CommentListImpl commentListImpl) throws BuildException {
        if (this.comments == null) {
            this.comments = commentListImpl;
        } else if (commentListImpl != null) {
            this.comments.add(commentListImpl);
        }
    }

    void apply(Annotated annotated) {
        annotated.setContext(new NamespaceContextImpl(this.context));
        if (this.comments != null) {
            annotated.getLeadingComments().addAll(this.comments.list);
        }
        annotated.getAttributeAnnotations().addAll(this.attributes);
        List<AnnotationChild> list = annotated.mayContainText() ? annotated.getFollowingElementAnnotations() : annotated.getChildElementAnnotations();
        list.addAll(this.elements);
    }
}

