/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.auto;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReceiver;
import com.thaiopensource.validate.auto.ReparseException;
import com.thaiopensource.validate.auto.Rewindable;
import com.thaiopensource.validate.auto.RewindableInputStream;
import com.thaiopensource.validate.auto.RewindableReader;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.auto.SchemaReceiverLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AutoSchemaReader
implements SchemaReader {
    private final SchemaReceiverFactory srf;

    public AutoSchemaReader() {
        this(new SchemaReceiverLoader());
    }

    public AutoSchemaReader(SchemaReceiverFactory schemaReceiverFactory) {
        this.srf = schemaReceiverFactory == null ? new SchemaReceiverLoader() : schemaReceiverFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema createSchema(InputSource inputSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        Object object;
        Object object2;
        Object object3;
        InputSource inputSource2;
        Object object4;
        if (SchemaReceiverFactory.PROPERTY.get(propertyMap) != this.srf) {
            object4 = new PropertyMapBuilder(propertyMap);
            SchemaReceiverFactory.PROPERTY.put((PropertyMapBuilder)object4, this.srf);
            propertyMap = ((PropertyMapBuilder)object4).toPropertyMap();
        }
        if ((object4 = ValidateProperty.ENTITY_RESOLVER.get(propertyMap)) != null && inputSource.getByteStream() == null && inputSource.getCharacterStream() == null && (inputSource2 = object4.resolveEntity(inputSource.getPublicId(), inputSource.getSystemId())) != null) {
            inputSource = inputSource2;
        }
        inputSource2 = new InputSource();
        inputSource2.setSystemId(inputSource.getSystemId());
        inputSource2.setPublicId(inputSource.getPublicId());
        inputSource2.setEncoding(inputSource.getEncoding());
        if (inputSource.getCharacterStream() != null) {
            object3 = new RewindableReader(inputSource.getCharacterStream());
            inputSource.setCharacterStream((Reader)object3);
            inputSource2.setCharacterStream((Reader)object3);
            object2 = object3;
        } else {
            object3 = inputSource.getByteStream();
            if (object3 == null) {
                object = inputSource.getSystemId();
                if (object == null) {
                    throw new IllegalArgumentException("null systemId and null byteStream");
                }
                object3 = new URL((String)object).openStream();
            }
            object = new RewindableInputStream((InputStream)object3);
            inputSource.setByteStream((InputStream)object);
            inputSource2.setByteStream((InputStream)object);
            object2 = object;
        }
        object3 = new AutoSchemaReceiver(propertyMap, (Rewindable)object2);
        object = ValidateProperty.XML_READER_CREATOR.get(propertyMap);
        XMLReader xMLReader = object.createXMLReader();
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        if (errorHandler != null) {
            xMLReader.setErrorHandler(errorHandler);
        }
        SchemaFuture schemaFuture = object3.installHandlers(xMLReader);
        try {
            xMLReader.parse(inputSource);
            Schema schema = schemaFuture.getSchema();
            object2.willNotRewind();
            return schema;
        }
        catch (ReparseException reparseException) {
            try {
                object2.rewind();
                object2.willNotRewind();
                Schema schema = reparseException.reparse(inputSource2);
                object2.willNotRewind();
                return schema;
            }
            catch (Throwable throwable) {
                try {
                    object2.willNotRewind();
                    throw throwable;
                }
                catch (SAXException sAXException) {
                    Exception exception = sAXException.getException();
                    if (exception instanceof RuntimeException) {
                        schemaFuture.unwrapException((RuntimeException)exception);
                    }
                    throw sAXException;
                }
                catch (RuntimeException runtimeException) {
                    throw schemaFuture.unwrapException(runtimeException);
                }
            }
        }
    }

    public Option getOption(String string) {
        return this.srf.getOption(string);
    }
}

