/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.mns;

import com.oxygenxml.validate.nvdl.NvdlProperty;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.mns.SchemaImpl;
import com.thaiopensource.validate.nrl.NrlProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.SAXSchemaReader;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private static final String MNS_SCHEMA = "mns.rng";
    private static final String RNC_MEDIA_TYPE = "application/x-rnc";
    private final PropertyMap properties;
    private final PropertyMap attributeSchemaProperties;
    private final boolean attributesSchema;
    private final SchemaReader autoSchemaLanguage;
    private Schema mnsSchema = null;

    public SchemaReceiverImpl(PropertyMap propertyMap) {
        this.attributesSchema = propertyMap.contains(NrlProperty.ATTRIBUTES_SCHEMA) || propertyMap.contains(NvdlProperty.ATTRIBUTES_SCHEMA);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(propertyMap);
        if (this.attributesSchema) {
            this.attributeSchemaProperties = propertyMap;
            propertyMapBuilder.put(NrlProperty.ATTRIBUTES_SCHEMA, null);
            propertyMapBuilder.put(NvdlProperty.ATTRIBUTES_SCHEMA, null);
            this.properties = propertyMapBuilder.toPropertyMap();
        } else {
            this.properties = propertyMap;
            NrlProperty.ATTRIBUTES_SCHEMA.add(propertyMapBuilder);
            NvdlProperty.ATTRIBUTES_SCHEMA.add(propertyMapBuilder);
            this.attributeSchemaProperties = propertyMapBuilder.toPropertyMap();
        }
        this.autoSchemaLanguage = new AutoSchemaReader(SchemaReceiverFactory.PROPERTY.get(propertyMap));
    }

    public SchemaFuture installHandlers(XMLReader xMLReader) {
        return new SchemaImpl(this.attributesSchema).installHandlers(xMLReader, this);
    }

    Schema getMnsSchema() throws IOException, IncorrectSchemaException, SAXException {
        if (this.mnsSchema == null) {
            String string = SchemaReceiverImpl.class.getName();
            String string2 = string.substring(0, string.lastIndexOf(46)).replace('.', '/') + "/resources/" + MNS_SCHEMA;
            URL uRL = SchemaReceiverImpl.getResource(string2);
            this.mnsSchema = SAXSchemaReader.getInstance().createSchema(new InputSource(uRL.toString()), this.properties);
        }
        return this.mnsSchema;
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = SchemaReceiverImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    PropertyMap getProperties() {
        return this.properties;
    }

    Schema createChildSchema(InputSource inputSource, String string, boolean bl) throws IOException, IncorrectSchemaException, SAXException {
        SchemaReader schemaReader = SchemaReceiverImpl.isRnc(string) ? CompactSchemaReader.getInstance() : this.autoSchemaLanguage;
        return schemaReader.createSchema(inputSource, bl ? this.attributeSchemaProperties : this.properties);
    }

    private static boolean isRnc(String string) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        return string.equals(RNC_MEDIA_TYPE);
    }
}

