/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class HelveticaBoldOblique
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Helvetica-BoldOblique";
    private static final String fullName = "Helvetica Bold Oblique";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 718;
    private static final int xHeight = 532;
    private static final int ascender = 718;
    private static final int descender = -207;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public HelveticaBoldOblique() {
        this(false);
    }

    public HelveticaBoldOblique(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncodingName() {
        return encoding;
    }

    public URI getFontURI() {
        return fontFileURI;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size) {
        return size * 718;
    }

    public int getCapHeight(int size) {
        return size * 718;
    }

    public int getDescender(int size) {
        return size * -207;
    }

    public int getXHeight(int size) {
        return size * 532;
    }

    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i, int size) {
        return size * width[i];
    }

    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + fontName.toLowerCase());
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        HelveticaBoldOblique.width[65] = 722;
        HelveticaBoldOblique.boundingBoxes[65] = new Rectangle(20, 0, 682, 718);
        HelveticaBoldOblique.width[198] = 1000;
        HelveticaBoldOblique.boundingBoxes[198] = new Rectangle(5, 0, 1095, 718);
        HelveticaBoldOblique.width[193] = 722;
        HelveticaBoldOblique.boundingBoxes[193] = new Rectangle(20, 0, 730, 936);
        HelveticaBoldOblique.width[194] = 722;
        HelveticaBoldOblique.boundingBoxes[194] = new Rectangle(20, 0, 686, 936);
        HelveticaBoldOblique.width[196] = 722;
        HelveticaBoldOblique.boundingBoxes[196] = new Rectangle(20, 0, 696, 915);
        HelveticaBoldOblique.width[192] = 722;
        HelveticaBoldOblique.boundingBoxes[192] = new Rectangle(20, 0, 682, 936);
        HelveticaBoldOblique.width[197] = 722;
        HelveticaBoldOblique.boundingBoxes[197] = new Rectangle(20, 0, 682, 962);
        HelveticaBoldOblique.width[195] = 722;
        HelveticaBoldOblique.boundingBoxes[195] = new Rectangle(20, 0, 721, 923);
        HelveticaBoldOblique.width[66] = 722;
        HelveticaBoldOblique.boundingBoxes[66] = new Rectangle(76, 0, 688, 718);
        HelveticaBoldOblique.width[67] = 722;
        HelveticaBoldOblique.boundingBoxes[67] = new Rectangle(107, -19, 682, 756);
        HelveticaBoldOblique.width[199] = 722;
        HelveticaBoldOblique.boundingBoxes[199] = new Rectangle(107, -228, 682, 965);
        HelveticaBoldOblique.width[68] = 722;
        HelveticaBoldOblique.boundingBoxes[68] = new Rectangle(76, 0, 701, 718);
        HelveticaBoldOblique.width[69] = 667;
        HelveticaBoldOblique.boundingBoxes[69] = new Rectangle(76, 0, 681, 718);
        HelveticaBoldOblique.width[201] = 667;
        HelveticaBoldOblique.boundingBoxes[201] = new Rectangle(76, 0, 681, 936);
        HelveticaBoldOblique.width[202] = 667;
        HelveticaBoldOblique.boundingBoxes[202] = new Rectangle(76, 0, 681, 936);
        HelveticaBoldOblique.width[203] = 667;
        HelveticaBoldOblique.boundingBoxes[203] = new Rectangle(76, 0, 681, 915);
        HelveticaBoldOblique.width[200] = 667;
        HelveticaBoldOblique.boundingBoxes[200] = new Rectangle(76, 0, 681, 936);
        HelveticaBoldOblique.width[208] = 722;
        HelveticaBoldOblique.boundingBoxes[208] = new Rectangle(62, 0, 715, 718);
        HelveticaBoldOblique.width[128] = 556;
        HelveticaBoldOblique.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        HelveticaBoldOblique.width[70] = 611;
        HelveticaBoldOblique.boundingBoxes[70] = new Rectangle(76, 0, 664, 718);
        HelveticaBoldOblique.width[71] = 778;
        HelveticaBoldOblique.boundingBoxes[71] = new Rectangle(108, -19, 709, 756);
        HelveticaBoldOblique.width[72] = 722;
        HelveticaBoldOblique.boundingBoxes[72] = new Rectangle(71, 0, 733, 718);
        HelveticaBoldOblique.width[73] = 278;
        HelveticaBoldOblique.boundingBoxes[73] = new Rectangle(64, 0, 303, 718);
        HelveticaBoldOblique.width[205] = 278;
        HelveticaBoldOblique.boundingBoxes[205] = new Rectangle(64, 0, 464, 936);
        HelveticaBoldOblique.width[206] = 278;
        HelveticaBoldOblique.boundingBoxes[206] = new Rectangle(64, 0, 420, 936);
        HelveticaBoldOblique.width[207] = 278;
        HelveticaBoldOblique.boundingBoxes[207] = new Rectangle(64, 0, 430, 915);
        HelveticaBoldOblique.width[204] = 278;
        HelveticaBoldOblique.boundingBoxes[204] = new Rectangle(64, 0, 303, 936);
        HelveticaBoldOblique.width[74] = 556;
        HelveticaBoldOblique.boundingBoxes[74] = new Rectangle(60, -18, 577, 736);
        HelveticaBoldOblique.width[75] = 722;
        HelveticaBoldOblique.boundingBoxes[75] = new Rectangle(87, 0, 771, 718);
        HelveticaBoldOblique.width[76] = 611;
        HelveticaBoldOblique.boundingBoxes[76] = new Rectangle(76, 0, 535, 718);
        HelveticaBoldOblique.width[77] = 833;
        HelveticaBoldOblique.boundingBoxes[77] = new Rectangle(69, 0, 849, 718);
        HelveticaBoldOblique.width[78] = 722;
        HelveticaBoldOblique.boundingBoxes[78] = new Rectangle(69, 0, 738, 718);
        HelveticaBoldOblique.width[209] = 722;
        HelveticaBoldOblique.boundingBoxes[209] = new Rectangle(69, 0, 738, 923);
        HelveticaBoldOblique.width[79] = 778;
        HelveticaBoldOblique.boundingBoxes[79] = new Rectangle(107, -19, 716, 756);
        HelveticaBoldOblique.width[140] = 1000;
        HelveticaBoldOblique.boundingBoxes[140] = new Rectangle(99, -19, 1015, 756);
        HelveticaBoldOblique.width[211] = 778;
        HelveticaBoldOblique.boundingBoxes[211] = new Rectangle(107, -19, 716, 955);
        HelveticaBoldOblique.width[212] = 778;
        HelveticaBoldOblique.boundingBoxes[212] = new Rectangle(107, -19, 716, 955);
        HelveticaBoldOblique.width[214] = 778;
        HelveticaBoldOblique.boundingBoxes[214] = new Rectangle(107, -19, 716, 934);
        HelveticaBoldOblique.width[210] = 778;
        HelveticaBoldOblique.boundingBoxes[210] = new Rectangle(107, -19, 716, 955);
        HelveticaBoldOblique.width[216] = 778;
        HelveticaBoldOblique.boundingBoxes[216] = new Rectangle(35, -27, 859, 772);
        HelveticaBoldOblique.width[213] = 778;
        HelveticaBoldOblique.boundingBoxes[213] = new Rectangle(107, -19, 716, 942);
        HelveticaBoldOblique.width[80] = 667;
        HelveticaBoldOblique.boundingBoxes[80] = new Rectangle(76, 0, 662, 718);
        HelveticaBoldOblique.width[81] = 778;
        HelveticaBoldOblique.boundingBoxes[81] = new Rectangle(107, -52, 716, 789);
        HelveticaBoldOblique.width[82] = 722;
        HelveticaBoldOblique.boundingBoxes[82] = new Rectangle(76, 0, 702, 718);
        HelveticaBoldOblique.width[83] = 667;
        HelveticaBoldOblique.boundingBoxes[83] = new Rectangle(81, -19, 637, 756);
        HelveticaBoldOblique.width[138] = 667;
        HelveticaBoldOblique.boundingBoxes[138] = new Rectangle(81, -19, 637, 955);
        HelveticaBoldOblique.width[84] = 611;
        HelveticaBoldOblique.boundingBoxes[84] = new Rectangle(140, 0, 611, 718);
        HelveticaBoldOblique.width[222] = 667;
        HelveticaBoldOblique.boundingBoxes[222] = new Rectangle(76, 0, 640, 718);
        HelveticaBoldOblique.width[85] = 722;
        HelveticaBoldOblique.boundingBoxes[85] = new Rectangle(116, -19, 688, 737);
        HelveticaBoldOblique.width[218] = 722;
        HelveticaBoldOblique.boundingBoxes[218] = new Rectangle(116, -19, 688, 955);
        HelveticaBoldOblique.width[219] = 722;
        HelveticaBoldOblique.boundingBoxes[219] = new Rectangle(116, -19, 688, 955);
        HelveticaBoldOblique.width[220] = 722;
        HelveticaBoldOblique.boundingBoxes[220] = new Rectangle(116, -19, 688, 934);
        HelveticaBoldOblique.width[217] = 722;
        HelveticaBoldOblique.boundingBoxes[217] = new Rectangle(116, -19, 688, 955);
        HelveticaBoldOblique.width[86] = 667;
        HelveticaBoldOblique.boundingBoxes[86] = new Rectangle(172, 0, 629, 718);
        HelveticaBoldOblique.width[87] = 944;
        HelveticaBoldOblique.boundingBoxes[87] = new Rectangle(169, 0, 913, 718);
        HelveticaBoldOblique.width[88] = 667;
        HelveticaBoldOblique.boundingBoxes[88] = new Rectangle(14, 0, 777, 718);
        HelveticaBoldOblique.width[89] = 667;
        HelveticaBoldOblique.boundingBoxes[89] = new Rectangle(168, 0, 638, 718);
        HelveticaBoldOblique.width[221] = 667;
        HelveticaBoldOblique.boundingBoxes[221] = new Rectangle(168, 0, 638, 936);
        HelveticaBoldOblique.width[159] = 667;
        HelveticaBoldOblique.boundingBoxes[159] = new Rectangle(168, 0, 638, 915);
        HelveticaBoldOblique.width[90] = 611;
        HelveticaBoldOblique.boundingBoxes[90] = new Rectangle(25, 0, 712, 718);
        HelveticaBoldOblique.width[142] = 611;
        HelveticaBoldOblique.boundingBoxes[142] = new Rectangle(25, 0, 712, 936);
        HelveticaBoldOblique.width[97] = 556;
        HelveticaBoldOblique.boundingBoxes[97] = new Rectangle(55, -14, 528, 560);
        HelveticaBoldOblique.width[225] = 556;
        HelveticaBoldOblique.boundingBoxes[225] = new Rectangle(55, -14, 572, 764);
        HelveticaBoldOblique.width[226] = 556;
        HelveticaBoldOblique.boundingBoxes[226] = new Rectangle(55, -14, 528, 764);
        HelveticaBoldOblique.width[180] = 333;
        HelveticaBoldOblique.boundingBoxes[180] = new Rectangle(236, 604, 279, 146);
        HelveticaBoldOblique.width[228] = 556;
        HelveticaBoldOblique.boundingBoxes[228] = new Rectangle(55, -14, 539, 743);
        HelveticaBoldOblique.width[230] = 889;
        HelveticaBoldOblique.boundingBoxes[230] = new Rectangle(56, -14, 867, 560);
        HelveticaBoldOblique.width[224] = 556;
        HelveticaBoldOblique.boundingBoxes[224] = new Rectangle(55, -14, 528, 764);
        HelveticaBoldOblique.width[38] = 722;
        HelveticaBoldOblique.boundingBoxes[38] = new Rectangle(89, -19, 643, 737);
        HelveticaBoldOblique.width[229] = 556;
        HelveticaBoldOblique.boundingBoxes[229] = new Rectangle(55, -14, 528, 790);
        HelveticaBoldOblique.width[94] = 584;
        HelveticaBoldOblique.boundingBoxes[94] = new Rectangle(131, 323, 460, 375);
        HelveticaBoldOblique.width[126] = 584;
        HelveticaBoldOblique.boundingBoxes[126] = new Rectangle(115, 163, 462, 180);
        HelveticaBoldOblique.width[42] = 389;
        HelveticaBoldOblique.boundingBoxes[42] = new Rectangle(146, 387, 335, 331);
        HelveticaBoldOblique.width[64] = 975;
        HelveticaBoldOblique.boundingBoxes[64] = new Rectangle(186, -19, 768, 756);
        HelveticaBoldOblique.width[227] = 556;
        HelveticaBoldOblique.boundingBoxes[227] = new Rectangle(55, -14, 564, 751);
        HelveticaBoldOblique.width[98] = 611;
        HelveticaBoldOblique.boundingBoxes[98] = new Rectangle(61, -14, 584, 732);
        HelveticaBoldOblique.width[92] = 278;
        HelveticaBoldOblique.boundingBoxes[92] = new Rectangle(124, -19, 183, 756);
        HelveticaBoldOblique.width[124] = 280;
        HelveticaBoldOblique.boundingBoxes[124] = new Rectangle(36, -225, 325, 1000);
        HelveticaBoldOblique.width[123] = 389;
        HelveticaBoldOblique.boundingBoxes[123] = new Rectangle(94, -196, 424, 918);
        HelveticaBoldOblique.width[125] = 389;
        HelveticaBoldOblique.boundingBoxes[125] = new Rectangle(-18, -196, 425, 918);
        HelveticaBoldOblique.width[91] = 333;
        HelveticaBoldOblique.boundingBoxes[91] = new Rectangle(21, -196, 441, 918);
        HelveticaBoldOblique.width[93] = 333;
        HelveticaBoldOblique.boundingBoxes[93] = new Rectangle(-18, -196, 441, 918);
        HelveticaBoldOblique.width[166] = 280;
        HelveticaBoldOblique.boundingBoxes[166] = new Rectangle(52, -150, 293, 850);
        HelveticaBoldOblique.width[149] = 350;
        HelveticaBoldOblique.boundingBoxes[149] = new Rectangle(83, 194, 337, 330);
        HelveticaBoldOblique.width[99] = 556;
        HelveticaBoldOblique.boundingBoxes[99] = new Rectangle(79, -14, 520, 560);
        HelveticaBoldOblique.width[231] = 556;
        HelveticaBoldOblique.boundingBoxes[231] = new Rectangle(79, -228, 520, 774);
        HelveticaBoldOblique.width[184] = 333;
        HelveticaBoldOblique.boundingBoxes[184] = new Rectangle(-37, -228, 257, 228);
        HelveticaBoldOblique.width[162] = 556;
        HelveticaBoldOblique.boundingBoxes[162] = new Rectangle(79, -118, 520, 746);
        HelveticaBoldOblique.width[136] = 333;
        HelveticaBoldOblique.boundingBoxes[136] = new Rectangle(118, 604, 353, 146);
        HelveticaBoldOblique.width[58] = 333;
        HelveticaBoldOblique.boundingBoxes[58] = new Rectangle(92, 0, 259, 512);
        HelveticaBoldOblique.width[44] = 278;
        HelveticaBoldOblique.boundingBoxes[44] = new Rectangle(28, -168, 217, 314);
        HelveticaBoldOblique.width[169] = 737;
        HelveticaBoldOblique.boundingBoxes[169] = new Rectangle(56, -19, 779, 756);
        HelveticaBoldOblique.width[164] = 556;
        HelveticaBoldOblique.boundingBoxes[164] = new Rectangle(27, 76, 653, 560);
        HelveticaBoldOblique.width[100] = 611;
        HelveticaBoldOblique.boundingBoxes[100] = new Rectangle(82, -14, 622, 732);
        HelveticaBoldOblique.width[134] = 556;
        HelveticaBoldOblique.boundingBoxes[134] = new Rectangle(118, -171, 508, 889);
        HelveticaBoldOblique.width[135] = 556;
        HelveticaBoldOblique.boundingBoxes[135] = new Rectangle(46, -171, 582, 889);
        HelveticaBoldOblique.width[176] = 400;
        HelveticaBoldOblique.boundingBoxes[176] = new Rectangle(175, 426, 292, 286);
        HelveticaBoldOblique.width[168] = 333;
        HelveticaBoldOblique.boundingBoxes[168] = new Rectangle(137, 614, 345, 115);
        HelveticaBoldOblique.width[247] = 584;
        HelveticaBoldOblique.boundingBoxes[247] = new Rectangle(82, -42, 528, 590);
        HelveticaBoldOblique.width[36] = 556;
        HelveticaBoldOblique.boundingBoxes[36] = new Rectangle(67, -115, 555, 890);
        HelveticaBoldOblique.width[101] = 556;
        HelveticaBoldOblique.boundingBoxes[101] = new Rectangle(70, -14, 523, 560);
        HelveticaBoldOblique.width[233] = 556;
        HelveticaBoldOblique.boundingBoxes[233] = new Rectangle(70, -14, 557, 764);
        HelveticaBoldOblique.width[234] = 556;
        HelveticaBoldOblique.boundingBoxes[234] = new Rectangle(70, -14, 523, 764);
        HelveticaBoldOblique.width[235] = 556;
        HelveticaBoldOblique.boundingBoxes[235] = new Rectangle(70, -14, 524, 743);
        HelveticaBoldOblique.width[232] = 556;
        HelveticaBoldOblique.boundingBoxes[232] = new Rectangle(70, -14, 523, 764);
        HelveticaBoldOblique.width[56] = 556;
        HelveticaBoldOblique.boundingBoxes[56] = new Rectangle(69, -19, 547, 729);
        HelveticaBoldOblique.width[133] = 1000;
        HelveticaBoldOblique.boundingBoxes[133] = new Rectangle(92, 0, 847, 146);
        HelveticaBoldOblique.width[151] = 1000;
        HelveticaBoldOblique.boundingBoxes[151] = new Rectangle(48, 227, 1023, 106);
        HelveticaBoldOblique.width[150] = 556;
        HelveticaBoldOblique.boundingBoxes[150] = new Rectangle(48, 227, 579, 106);
        HelveticaBoldOblique.width[61] = 584;
        HelveticaBoldOblique.boundingBoxes[61] = new Rectangle(58, 87, 575, 332);
        HelveticaBoldOblique.width[240] = 611;
        HelveticaBoldOblique.boundingBoxes[240] = new Rectangle(82, -14, 588, 751);
        HelveticaBoldOblique.width[33] = 333;
        HelveticaBoldOblique.boundingBoxes[33] = new Rectangle(94, 0, 303, 718);
        HelveticaBoldOblique.width[161] = 333;
        HelveticaBoldOblique.boundingBoxes[161] = new Rectangle(50, -186, 303, 718);
        HelveticaBoldOblique.width[102] = 333;
        HelveticaBoldOblique.boundingBoxes[102] = new Rectangle(87, 0, 382, 727);
        HelveticaBoldOblique.width[53] = 556;
        HelveticaBoldOblique.boundingBoxes[53] = new Rectangle(64, -19, 572, 717);
        HelveticaBoldOblique.width[131] = 556;
        HelveticaBoldOblique.boundingBoxes[131] = new Rectangle(-50, -210, 719, 947);
        HelveticaBoldOblique.width[52] = 556;
        HelveticaBoldOblique.boundingBoxes[52] = new Rectangle(60, 0, 538, 710);
        HelveticaBoldOblique.width[103] = 611;
        HelveticaBoldOblique.boundingBoxes[103] = new Rectangle(38, -217, 628, 763);
        HelveticaBoldOblique.width[223] = 611;
        HelveticaBoldOblique.boundingBoxes[223] = new Rectangle(69, -14, 588, 745);
        HelveticaBoldOblique.width[96] = 333;
        HelveticaBoldOblique.boundingBoxes[96] = new Rectangle(136, 604, 217, 146);
        HelveticaBoldOblique.width[62] = 584;
        HelveticaBoldOblique.boundingBoxes[62] = new Rectangle(36, -8, 573, 522);
        HelveticaBoldOblique.width[171] = 556;
        HelveticaBoldOblique.boundingBoxes[171] = new Rectangle(135, 76, 436, 408);
        HelveticaBoldOblique.width[187] = 556;
        HelveticaBoldOblique.boundingBoxes[187] = new Rectangle(104, 76, 436, 408);
        HelveticaBoldOblique.width[139] = 333;
        HelveticaBoldOblique.boundingBoxes[139] = new Rectangle(130, 76, 223, 408);
        HelveticaBoldOblique.width[155] = 333;
        HelveticaBoldOblique.boundingBoxes[155] = new Rectangle(99, 76, 223, 408);
        HelveticaBoldOblique.width[104] = 611;
        HelveticaBoldOblique.boundingBoxes[104] = new Rectangle(65, 0, 564, 718);
        HelveticaBoldOblique.width[45] = 333;
        HelveticaBoldOblique.boundingBoxes[45] = new Rectangle(73, 215, 306, 130);
        HelveticaBoldOblique.width[105] = 278;
        HelveticaBoldOblique.boundingBoxes[105] = new Rectangle(69, 0, 294, 725);
        HelveticaBoldOblique.width[237] = 278;
        HelveticaBoldOblique.boundingBoxes[237] = new Rectangle(69, 0, 419, 750);
        HelveticaBoldOblique.width[238] = 278;
        HelveticaBoldOblique.boundingBoxes[238] = new Rectangle(69, 0, 375, 750);
        HelveticaBoldOblique.width[239] = 278;
        HelveticaBoldOblique.boundingBoxes[239] = new Rectangle(69, 0, 386, 729);
        HelveticaBoldOblique.width[236] = 278;
        HelveticaBoldOblique.boundingBoxes[236] = new Rectangle(69, 0, 257, 750);
        HelveticaBoldOblique.width[106] = 278;
        HelveticaBoldOblique.boundingBoxes[106] = new Rectangle(-42, -214, 405, 939);
        HelveticaBoldOblique.width[107] = 556;
        HelveticaBoldOblique.boundingBoxes[107] = new Rectangle(69, 0, 601, 718);
        HelveticaBoldOblique.width[108] = 278;
        HelveticaBoldOblique.boundingBoxes[108] = new Rectangle(69, 0, 293, 718);
        HelveticaBoldOblique.width[60] = 584;
        HelveticaBoldOblique.boundingBoxes[60] = new Rectangle(82, -8, 573, 522);
        HelveticaBoldOblique.width[172] = 584;
        HelveticaBoldOblique.boundingBoxes[172] = new Rectangle(105, 108, 528, 311);
        HelveticaBoldOblique.width[109] = 889;
        HelveticaBoldOblique.boundingBoxes[109] = new Rectangle(64, 0, 845, 546);
        HelveticaBoldOblique.width[175] = 333;
        HelveticaBoldOblique.boundingBoxes[175] = new Rectangle(122, 604, 361, 74);
        HelveticaBoldOblique.width[181] = 611;
        HelveticaBoldOblique.boundingBoxes[181] = new Rectangle(22, -207, 636, 739);
        HelveticaBoldOblique.width[215] = 584;
        HelveticaBoldOblique.boundingBoxes[215] = new Rectangle(57, 1, 578, 504);
        HelveticaBoldOblique.width[110] = 611;
        HelveticaBoldOblique.boundingBoxes[110] = new Rectangle(65, 0, 564, 546);
        HelveticaBoldOblique.width[57] = 556;
        HelveticaBoldOblique.boundingBoxes[57] = new Rectangle(78, -19, 537, 729);
        HelveticaBoldOblique.width[241] = 611;
        HelveticaBoldOblique.boundingBoxes[241] = new Rectangle(65, 0, 581, 737);
        HelveticaBoldOblique.width[35] = 556;
        HelveticaBoldOblique.boundingBoxes[35] = new Rectangle(60, 0, 584, 698);
        HelveticaBoldOblique.width[111] = 611;
        HelveticaBoldOblique.boundingBoxes[111] = new Rectangle(82, -14, 561, 560);
        HelveticaBoldOblique.width[243] = 611;
        HelveticaBoldOblique.boundingBoxes[243] = new Rectangle(82, -14, 572, 764);
        HelveticaBoldOblique.width[244] = 611;
        HelveticaBoldOblique.boundingBoxes[244] = new Rectangle(82, -14, 561, 764);
        HelveticaBoldOblique.width[246] = 611;
        HelveticaBoldOblique.boundingBoxes[246] = new Rectangle(82, -14, 561, 743);
        HelveticaBoldOblique.width[156] = 944;
        HelveticaBoldOblique.boundingBoxes[156] = new Rectangle(82, -14, 895, 560);
        HelveticaBoldOblique.width[242] = 611;
        HelveticaBoldOblique.boundingBoxes[242] = new Rectangle(82, -14, 561, 764);
        HelveticaBoldOblique.width[49] = 556;
        HelveticaBoldOblique.boundingBoxes[49] = new Rectangle(173, 0, 356, 710);
        HelveticaBoldOblique.width[189] = 834;
        HelveticaBoldOblique.boundingBoxes[189] = new Rectangle(132, -19, 726, 729);
        HelveticaBoldOblique.width[188] = 834;
        HelveticaBoldOblique.boundingBoxes[188] = new Rectangle(132, -19, 674, 729);
        HelveticaBoldOblique.width[185] = 333;
        HelveticaBoldOblique.boundingBoxes[185] = new Rectangle(148, 283, 240, 427);
        HelveticaBoldOblique.width[170] = 370;
        HelveticaBoldOblique.boundingBoxes[170] = new Rectangle(125, 401, 340, 336);
        HelveticaBoldOblique.width[186] = 365;
        HelveticaBoldOblique.boundingBoxes[186] = new Rectangle(123, 401, 362, 336);
        HelveticaBoldOblique.width[248] = 611;
        HelveticaBoldOblique.boundingBoxes[248] = new Rectangle(22, -29, 679, 589);
        HelveticaBoldOblique.width[245] = 611;
        HelveticaBoldOblique.boundingBoxes[245] = new Rectangle(82, -14, 564, 751);
        HelveticaBoldOblique.width[112] = 611;
        HelveticaBoldOblique.boundingBoxes[112] = new Rectangle(18, -207, 627, 753);
        HelveticaBoldOblique.width[182] = 556;
        HelveticaBoldOblique.boundingBoxes[182] = new Rectangle(98, -191, 590, 891);
        HelveticaBoldOblique.width[40] = 333;
        HelveticaBoldOblique.boundingBoxes[40] = new Rectangle(76, -208, 394, 942);
        HelveticaBoldOblique.width[41] = 333;
        HelveticaBoldOblique.boundingBoxes[41] = new Rectangle(-25, -208, 394, 942);
        HelveticaBoldOblique.width[37] = 889;
        HelveticaBoldOblique.boundingBoxes[37] = new Rectangle(136, -19, 765, 729);
        HelveticaBoldOblique.width[46] = 278;
        HelveticaBoldOblique.boundingBoxes[46] = new Rectangle(64, 0, 181, 146);
        HelveticaBoldOblique.width[183] = 278;
        HelveticaBoldOblique.boundingBoxes[183] = new Rectangle(110, 172, 166, 162);
        HelveticaBoldOblique.width[137] = 1000;
        HelveticaBoldOblique.boundingBoxes[137] = new Rectangle(76, -19, 962, 729);
        HelveticaBoldOblique.width[43] = 584;
        HelveticaBoldOblique.boundingBoxes[43] = new Rectangle(82, 0, 528, 506);
        HelveticaBoldOblique.width[177] = 584;
        HelveticaBoldOblique.boundingBoxes[177] = new Rectangle(40, 0, 585, 506);
        HelveticaBoldOblique.width[113] = 611;
        HelveticaBoldOblique.boundingBoxes[113] = new Rectangle(80, -207, 585, 753);
        HelveticaBoldOblique.width[63] = 611;
        HelveticaBoldOblique.boundingBoxes[63] = new Rectangle(165, 0, 506, 727);
        HelveticaBoldOblique.width[191] = 611;
        HelveticaBoldOblique.boundingBoxes[191] = new Rectangle(53, -195, 506, 727);
        HelveticaBoldOblique.width[34] = 474;
        HelveticaBoldOblique.boundingBoxes[34] = new Rectangle(193, 447, 336, 271);
        HelveticaBoldOblique.width[132] = 500;
        HelveticaBoldOblique.boundingBoxes[132] = new Rectangle(36, -146, 427, 273);
        HelveticaBoldOblique.width[147] = 500;
        HelveticaBoldOblique.boundingBoxes[147] = new Rectangle(160, 454, 428, 273);
        HelveticaBoldOblique.width[148] = 500;
        HelveticaBoldOblique.boundingBoxes[148] = new Rectangle(162, 445, 427, 273);
        HelveticaBoldOblique.width[145] = 278;
        HelveticaBoldOblique.boundingBoxes[145] = new Rectangle(165, 454, 196, 273);
        HelveticaBoldOblique.width[146] = 278;
        HelveticaBoldOblique.boundingBoxes[146] = new Rectangle(167, 445, 195, 273);
        HelveticaBoldOblique.width[130] = 278;
        HelveticaBoldOblique.boundingBoxes[130] = new Rectangle(41, -146, 195, 273);
        HelveticaBoldOblique.width[39] = 238;
        HelveticaBoldOblique.boundingBoxes[39] = new Rectangle(165, 447, 156, 271);
        HelveticaBoldOblique.width[114] = 389;
        HelveticaBoldOblique.boundingBoxes[114] = new Rectangle(64, 0, 425, 546);
        HelveticaBoldOblique.width[174] = 737;
        HelveticaBoldOblique.boundingBoxes[174] = new Rectangle(55, -19, 779, 756);
        HelveticaBoldOblique.width[115] = 556;
        HelveticaBoldOblique.boundingBoxes[115] = new Rectangle(63, -14, 521, 560);
        HelveticaBoldOblique.width[154] = 556;
        HelveticaBoldOblique.boundingBoxes[154] = new Rectangle(63, -14, 551, 764);
        HelveticaBoldOblique.width[167] = 556;
        HelveticaBoldOblique.boundingBoxes[167] = new Rectangle(61, -184, 537, 911);
        HelveticaBoldOblique.width[59] = 333;
        HelveticaBoldOblique.boundingBoxes[59] = new Rectangle(56, -168, 295, 680);
        HelveticaBoldOblique.width[55] = 556;
        HelveticaBoldOblique.boundingBoxes[55] = new Rectangle(125, 0, 551, 698);
        HelveticaBoldOblique.width[54] = 556;
        HelveticaBoldOblique.boundingBoxes[54] = new Rectangle(85, -19, 534, 729);
        HelveticaBoldOblique.width[47] = 278;
        HelveticaBoldOblique.boundingBoxes[47] = new Rectangle(-37, -19, 505, 756);
        HelveticaBoldOblique.width[32] = 278;
        HelveticaBoldOblique.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        HelveticaBoldOblique.width[163] = 556;
        HelveticaBoldOblique.boundingBoxes[163] = new Rectangle(50, -16, 585, 734);
        HelveticaBoldOblique.width[116] = 333;
        HelveticaBoldOblique.boundingBoxes[116] = new Rectangle(100, -6, 322, 682);
        HelveticaBoldOblique.width[254] = 611;
        HelveticaBoldOblique.boundingBoxes[254] = new Rectangle(18, -208, 627, 926);
        HelveticaBoldOblique.width[51] = 556;
        HelveticaBoldOblique.boundingBoxes[51] = new Rectangle(65, -19, 543, 729);
        HelveticaBoldOblique.width[190] = 834;
        HelveticaBoldOblique.boundingBoxes[190] = new Rectangle(99, -19, 740, 729);
        HelveticaBoldOblique.width[179] = 333;
        HelveticaBoldOblique.boundingBoxes[179] = new Rectangle(91, 271, 350, 439);
        HelveticaBoldOblique.width[152] = 333;
        HelveticaBoldOblique.boundingBoxes[152] = new Rectangle(113, 610, 394, 127);
        HelveticaBoldOblique.width[153] = 1000;
        HelveticaBoldOblique.boundingBoxes[153] = new Rectangle(179, 306, 930, 412);
        HelveticaBoldOblique.width[50] = 556;
        HelveticaBoldOblique.boundingBoxes[50] = new Rectangle(26, 0, 593, 710);
        HelveticaBoldOblique.width[178] = 333;
        HelveticaBoldOblique.boundingBoxes[178] = new Rectangle(69, 283, 380, 427);
        HelveticaBoldOblique.width[117] = 611;
        HelveticaBoldOblique.boundingBoxes[117] = new Rectangle(98, -14, 560, 546);
        HelveticaBoldOblique.width[250] = 611;
        HelveticaBoldOblique.boundingBoxes[250] = new Rectangle(98, -14, 560, 764);
        HelveticaBoldOblique.width[251] = 611;
        HelveticaBoldOblique.boundingBoxes[251] = new Rectangle(98, -14, 560, 764);
        HelveticaBoldOblique.width[252] = 611;
        HelveticaBoldOblique.boundingBoxes[252] = new Rectangle(98, -14, 560, 743);
        HelveticaBoldOblique.width[249] = 611;
        HelveticaBoldOblique.boundingBoxes[249] = new Rectangle(98, -14, 560, 764);
        HelveticaBoldOblique.width[95] = 556;
        HelveticaBoldOblique.boundingBoxes[95] = new Rectangle(-27, -125, 567, 50);
        HelveticaBoldOblique.width[118] = 556;
        HelveticaBoldOblique.boundingBoxes[118] = new Rectangle(126, 0, 530, 532);
        HelveticaBoldOblique.width[119] = 778;
        HelveticaBoldOblique.boundingBoxes[119] = new Rectangle(123, 0, 759, 532);
        HelveticaBoldOblique.width[120] = 556;
        HelveticaBoldOblique.boundingBoxes[120] = new Rectangle(15, 0, 633, 532);
        HelveticaBoldOblique.width[121] = 556;
        HelveticaBoldOblique.boundingBoxes[121] = new Rectangle(42, -214, 610, 746);
        HelveticaBoldOblique.width[253] = 556;
        HelveticaBoldOblique.boundingBoxes[253] = new Rectangle(42, -214, 610, 964);
        HelveticaBoldOblique.width[255] = 556;
        HelveticaBoldOblique.boundingBoxes[255] = new Rectangle(42, -214, 610, 943);
        HelveticaBoldOblique.width[165] = 556;
        HelveticaBoldOblique.boundingBoxes[165] = new Rectangle(60, 0, 653, 698);
        HelveticaBoldOblique.width[122] = 500;
        HelveticaBoldOblique.boundingBoxes[122] = new Rectangle(20, 0, 563, 532);
        HelveticaBoldOblique.width[158] = 500;
        HelveticaBoldOblique.boundingBoxes[158] = new Rectangle(20, 0, 566, 750);
        HelveticaBoldOblique.width[48] = 556;
        HelveticaBoldOblique.boundingBoxes[48] = new Rectangle(86, -19, 531, 729);
        kerning = new HashMap();
        Integer first = new Integer(107);
        Map<Integer, Integer> pairs = (HashMap<Integer, Integer>)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap<Integer, Integer>();
            kerning.put(first, pairs);
        }
        Integer second = new Integer(111);
        pairs.put(second, new Integer(-15));
        first = new Integer(79);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-50));
        second = new Integer(87);
        pairs.put(second, new Integer(-50));
        second = new Integer(89);
        pairs.put(second, new Integer(-70));
        second = new Integer(84);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        second = new Integer(88);
        pairs.put(second, new Integer(-50));
        second = new Integer(44);
        pairs.put(second, new Integer(-40));
        first = new Integer(104);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        first = new Integer(99);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(107);
        pairs.put(second, new Integer(-20));
        second = new Integer(104);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(-10));
        second = new Integer(108);
        pairs.put(second, new Integer(-20));
        first = new Integer(87);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-60));
        second = new Integer(45);
        pairs.put(second, new Integer(-40));
        second = new Integer(79);
        pairs.put(second, new Integer(-20));
        second = new Integer(58);
        pairs.put(second, new Integer(-10));
        second = new Integer(97);
        pairs.put(second, new Integer(-40));
        second = new Integer(65);
        pairs.put(second, new Integer(-60));
        second = new Integer(117);
        pairs.put(second, new Integer(-45));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(101);
        pairs.put(second, new Integer(-35));
        second = new Integer(59);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        first = new Integer(112);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        first = new Integer(80);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-40));
        second = new Integer(97);
        pairs.put(second, new Integer(-30));
        second = new Integer(65);
        pairs.put(second, new Integer(-100));
        second = new Integer(46);
        pairs.put(second, new Integer(-120));
        second = new Integer(101);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-120));
        first = new Integer(86);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-90));
        second = new Integer(45);
        pairs.put(second, new Integer(-80));
        second = new Integer(79);
        pairs.put(second, new Integer(-50));
        second = new Integer(58);
        pairs.put(second, new Integer(-40));
        second = new Integer(97);
        pairs.put(second, new Integer(-60));
        second = new Integer(65);
        pairs.put(second, new Integer(-80));
        second = new Integer(117);
        pairs.put(second, new Integer(-60));
        second = new Integer(46);
        pairs.put(second, new Integer(-120));
        second = new Integer(71);
        pairs.put(second, new Integer(-50));
        second = new Integer(101);
        pairs.put(second, new Integer(-50));
        second = new Integer(59);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(-120));
        first = new Integer(59);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(-40));
        first = new Integer(118);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-30));
        second = new Integer(97);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        first = new Integer(32);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(87);
        pairs.put(second, new Integer(-80));
        second = new Integer(147);
        pairs.put(second, new Integer(-80));
        second = new Integer(89);
        pairs.put(second, new Integer(-120));
        second = new Integer(84);
        pairs.put(second, new Integer(-100));
        second = new Integer(145);
        pairs.put(second, new Integer(-60));
        second = new Integer(86);
        pairs.put(second, new Integer(-80));
        first = new Integer(97);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(103);
        pairs.put(second, new Integer(-10));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        first = new Integer(65);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(119);
        pairs.put(second, new Integer(-30));
        second = new Integer(87);
        pairs.put(second, new Integer(-60));
        second = new Integer(67);
        pairs.put(second, new Integer(-40));
        second = new Integer(81);
        pairs.put(second, new Integer(-40));
        second = new Integer(71);
        pairs.put(second, new Integer(-50));
        second = new Integer(86);
        pairs.put(second, new Integer(-80));
        second = new Integer(118);
        pairs.put(second, new Integer(-40));
        second = new Integer(85);
        pairs.put(second, new Integer(-50));
        second = new Integer(117);
        pairs.put(second, new Integer(-30));
        second = new Integer(89);
        pairs.put(second, new Integer(-110));
        second = new Integer(84);
        pairs.put(second, new Integer(-90));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        first = new Integer(70);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(97);
        pairs.put(second, new Integer(-20));
        second = new Integer(65);
        pairs.put(second, new Integer(-80));
        second = new Integer(46);
        pairs.put(second, new Integer(-100));
        second = new Integer(44);
        pairs.put(second, new Integer(-100));
        first = new Integer(85);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-50));
        second = new Integer(46);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-30));
        first = new Integer(115);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        first = new Integer(111);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(120);
        pairs.put(second, new Integer(-30));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(122);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(101);
        pairs.put(second, new Integer(10));
        first = new Integer(100);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(100);
        pairs.put(second, new Integer(-10));
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        first = new Integer(68);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-40));
        second = new Integer(87);
        pairs.put(second, new Integer(-40));
        second = new Integer(89);
        pairs.put(second, new Integer(-70));
        second = new Integer(46);
        pairs.put(second, new Integer(-30));
        second = new Integer(86);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(-30));
        first = new Integer(146);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(100);
        pairs.put(second, new Integer(-80));
        second = new Integer(32);
        pairs.put(second, new Integer(-80));
        second = new Integer(146);
        pairs.put(second, new Integer(-46));
        second = new Integer(114);
        pairs.put(second, new Integer(-40));
        second = new Integer(108);
        pairs.put(second, new Integer(-20));
        second = new Integer(115);
        pairs.put(second, new Integer(-60));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(82);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-20));
        second = new Integer(87);
        pairs.put(second, new Integer(-40));
        second = new Integer(85);
        pairs.put(second, new Integer(-20));
        second = new Integer(89);
        pairs.put(second, new Integer(-50));
        second = new Integer(84);
        pairs.put(second, new Integer(-20));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        first = new Integer(75);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-35));
        second = new Integer(79);
        pairs.put(second, new Integer(-30));
        second = new Integer(117);
        pairs.put(second, new Integer(-30));
        second = new Integer(121);
        pairs.put(second, new Integer(-40));
        second = new Integer(101);
        pairs.put(second, new Integer(-15));
        first = new Integer(58);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(-40));
        first = new Integer(119);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(-40));
        first = new Integer(114);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(100);
        pairs.put(second, new Integer(-20));
        second = new Integer(45);
        pairs.put(second, new Integer(-20));
        second = new Integer(99);
        pairs.put(second, new Integer(-20));
        second = new Integer(116);
        pairs.put(second, new Integer(20));
        second = new Integer(121);
        pairs.put(second, new Integer(10));
        second = new Integer(46);
        pairs.put(second, new Integer(-60));
        second = new Integer(103);
        pairs.put(second, new Integer(-15));
        second = new Integer(113);
        pairs.put(second, new Integer(-20));
        second = new Integer(115);
        pairs.put(second, new Integer(-15));
        second = new Integer(118);
        pairs.put(second, new Integer(10));
        second = new Integer(44);
        pairs.put(second, new Integer(-60));
        first = new Integer(145);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(145);
        pairs.put(second, new Integer(-46));
        first = new Integer(108);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        first = new Integer(103);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(103);
        pairs.put(second, new Integer(-10));
        second = new Integer(101);
        pairs.put(second, new Integer(10));
        first = new Integer(66);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-30));
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        first = new Integer(98);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(108);
        pairs.put(second, new Integer(-10));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(76);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-140));
        second = new Integer(146);
        pairs.put(second, new Integer(-140));
        second = new Integer(87);
        pairs.put(second, new Integer(-80));
        second = new Integer(89);
        pairs.put(second, new Integer(-120));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        second = new Integer(84);
        pairs.put(second, new Integer(-90));
        second = new Integer(86);
        pairs.put(second, new Integer(-110));
        first = new Integer(81);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(20));
        second = new Integer(44);
        pairs.put(second, new Integer(20));
        first = new Integer(44);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-120));
        second = new Integer(32);
        pairs.put(second, new Integer(-40));
        second = new Integer(146);
        pairs.put(second, new Integer(-120));
        first = new Integer(148);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(-80));
        first = new Integer(109);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        first = new Integer(102);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(30));
        second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(146);
        pairs.put(second, new Integer(30));
        second = new Integer(46);
        pairs.put(second, new Integer(-10));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-10));
        first = new Integer(74);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-20));
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-20));
        second = new Integer(44);
        pairs.put(second, new Integer(-20));
        first = new Integer(89);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-100));
        second = new Integer(79);
        pairs.put(second, new Integer(-70));
        second = new Integer(58);
        pairs.put(second, new Integer(-50));
        second = new Integer(97);
        pairs.put(second, new Integer(-90));
        second = new Integer(65);
        pairs.put(second, new Integer(-110));
        second = new Integer(117);
        pairs.put(second, new Integer(-100));
        second = new Integer(46);
        pairs.put(second, new Integer(-100));
        second = new Integer(101);
        pairs.put(second, new Integer(-80));
        second = new Integer(59);
        pairs.put(second, new Integer(-50));
        second = new Integer(44);
        pairs.put(second, new Integer(-100));
        first = new Integer(84);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-80));
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(58);
        pairs.put(second, new Integer(-40));
        second = new Integer(119);
        pairs.put(second, new Integer(-60));
        second = new Integer(114);
        pairs.put(second, new Integer(-80));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        second = new Integer(59);
        pairs.put(second, new Integer(-40));
        second = new Integer(45);
        pairs.put(second, new Integer(-120));
        second = new Integer(65);
        pairs.put(second, new Integer(-90));
        second = new Integer(97);
        pairs.put(second, new Integer(-80));
        second = new Integer(117);
        pairs.put(second, new Integer(-90));
        second = new Integer(121);
        pairs.put(second, new Integer(-60));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(101);
        pairs.put(second, new Integer(-60));
        first = new Integer(121);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-25));
        second = new Integer(97);
        pairs.put(second, new Integer(-30));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        first = new Integer(46);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-120));
        second = new Integer(32);
        pairs.put(second, new Integer(-40));
        second = new Integer(146);
        pairs.put(second, new Integer(-120));
        first = new Integer(110);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(118);
        pairs.put(second, new Integer(-40));
        first = new Integer(120);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        first = new Integer(101);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(46);
        pairs.put(second, new Integer(20));
        second = new Integer(120);
        pairs.put(second, new Integer(-15));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(10));
        familyNames = new HashSet();
        familyNames.add("Helvetica");
    }
}

