/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.GenericReflection;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ArrayHelper {
    private static final ArrayHelper s_aInstance = new ArrayHelper();

    private ArrayHelper() {
    }

    @Nonnull
    public static <DATATYPE> Class<? extends DATATYPE> getComponentType(@Nonnull DATATYPE[] aArray) {
        if (aArray == null) {
            throw new NullPointerException("array");
        }
        Class<?> aComponentType = aArray.getClass().getComponentType();
        return (Class)GenericReflection.uncheckedCast(aComponentType);
    }

    public static boolean isArray(@Nullable Object aObject) {
        return aObject != null && ClassHelper.isArrayClass(aObject.getClass());
    }

    @Nonnegative
    public static int getSize(boolean ... aArray) {
        return aArray == null ? 0 : aArray.length;
    }

    @Nonnegative
    public static int getSize(byte ... aArray) {
        return aArray == null ? 0 : aArray.length;
    }

    @Nonnegative
    public static int getSize(char ... aArray) {
        return aArray == null ? 0 : aArray.length;
    }

    @Nonnegative
    public static int getSize(double ... aArray) {
        return aArray == null ? 0 : aArray.length;
    }

    @Nonnegative
    public static int getSize(float ... aArray) {
        return aArray == null ? 0 : aArray.length;
    }

    @Nonnegative
    public static int getSize(int ... aArray) {
        return aArray == null ? 0 : aArray.length;
    }

    @Nonnegative
    public static int getSize(long ... aArray) {
        return aArray == null ? 0 : aArray.length;
    }

    @Nonnegative
    public static int getSize(short ... aArray) {
        return aArray == null ? 0 : aArray.length;
    }

    @Nonnegative
    public static <ELEMENTTYPE> int getSize(ELEMENTTYPE ... aArray) {
        return aArray == null ? 0 : aArray.length;
    }

    public static boolean isEmpty(boolean ... aArray) {
        return ArrayHelper.getSize(aArray) == 0;
    }

    public static boolean isEmpty(byte ... aArray) {
        return ArrayHelper.getSize(aArray) == 0;
    }

    public static boolean isEmpty(char ... aArray) {
        return ArrayHelper.getSize(aArray) == 0;
    }

    public static boolean isEmpty(double ... aArray) {
        return ArrayHelper.getSize(aArray) == 0;
    }

    public static boolean isEmpty(float ... aArray) {
        return ArrayHelper.getSize(aArray) == 0;
    }

    public static boolean isEmpty(int ... aArray) {
        return ArrayHelper.getSize(aArray) == 0;
    }

    public static boolean isEmpty(long ... aArray) {
        return ArrayHelper.getSize(aArray) == 0;
    }

    public static boolean isEmpty(short ... aArray) {
        return ArrayHelper.getSize(aArray) == 0;
    }

    public static <ELEMENTTYPE> boolean isEmpty(ELEMENTTYPE ... aArray) {
        return ArrayHelper.getSize(aArray) == 0;
    }

    public static boolean isNotEmpty(boolean ... aArray) {
        return ArrayHelper.getSize(aArray) > 0;
    }

    public static boolean isNotEmpty(byte ... aArray) {
        return ArrayHelper.getSize(aArray) > 0;
    }

    public static boolean isNotEmpty(char ... aArray) {
        return ArrayHelper.getSize(aArray) > 0;
    }

    public static boolean isNotEmpty(double ... aArray) {
        return ArrayHelper.getSize(aArray) > 0;
    }

    public static boolean isNotEmpty(float ... aArray) {
        return ArrayHelper.getSize(aArray) > 0;
    }

    public static boolean isNotEmpty(int ... aArray) {
        return ArrayHelper.getSize(aArray) > 0;
    }

    public static boolean isNotEmpty(long ... aArray) {
        return ArrayHelper.getSize(aArray) > 0;
    }

    public static boolean isNotEmpty(short ... aArray) {
        return ArrayHelper.getSize(aArray) > 0;
    }

    public static <ELEMENTTYPE> boolean isNotEmpty(ELEMENTTYPE ... aArray) {
        return ArrayHelper.getSize(aArray) > 0;
    }

    public static <ELEMENTTYPE> int getFirstIndex(@Nullable ELEMENTTYPE[] aValues, @Nullable ELEMENTTYPE aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable boolean[] aValues, boolean aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable byte[] aValues, byte aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable char[] aValues, char aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable double[] aValues, double aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable float[] aValues, float aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable int[] aValues, int aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable long[] aValues, long aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable short[] aValues, short aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static <ELEMENTTYPE> int getLastIndex(@Nullable ELEMENTTYPE[] aValues, @Nullable ELEMENTTYPE aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = nLength - 1; nIndex >= 0; --nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable boolean[] aValues, boolean aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = nLength - 1; nIndex >= 0; --nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable byte[] aValues, byte aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = nLength - 1; nIndex >= 0; --nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable char[] aValues, char aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = nLength - 1; nIndex >= 0; --nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable double[] aValues, double aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = nLength - 1; nIndex >= 0; --nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable float[] aValues, float aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = nLength - 1; nIndex >= 0; --nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable int[] aValues, int aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = nLength - 1; nIndex >= 0; --nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable long[] aValues, long aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = nLength - 1; nIndex >= 0; --nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable short[] aValues, short aSearchValue) {
        int nLength = ArrayHelper.getSize(aValues);
        if (nLength > 0) {
            for (int nIndex = nLength - 1; nIndex >= 0; --nIndex) {
                if (!EqualsUtils.equals(aValues[nIndex], aSearchValue)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    public static <ELEMENTTYPE> boolean contains(@Nullable ELEMENTTYPE[] aValues, @Nullable ELEMENTTYPE aSearchValue) {
        return ArrayHelper.getFirstIndex(aValues, aSearchValue) >= 0;
    }

    public static boolean contains(@Nullable boolean[] aValues, boolean aSearchValue) {
        return ArrayHelper.getFirstIndex(aValues, aSearchValue) >= 0;
    }

    public static boolean contains(@Nullable byte[] aValues, byte aSearchValue) {
        return ArrayHelper.getFirstIndex(aValues, aSearchValue) >= 0;
    }

    public static boolean contains(@Nullable char[] aValues, char aSearchValue) {
        return ArrayHelper.getFirstIndex(aValues, aSearchValue) >= 0;
    }

    public static boolean contains(@Nullable double[] aValues, double aSearchValue) {
        return ArrayHelper.getFirstIndex(aValues, aSearchValue) >= 0;
    }

    public static boolean contains(@Nullable float[] aValues, float aSearchValue) {
        return ArrayHelper.getFirstIndex(aValues, aSearchValue) >= 0;
    }

    public static boolean contains(@Nullable int[] aValues, int aSearchValue) {
        return ArrayHelper.getFirstIndex(aValues, aSearchValue) >= 0;
    }

    public static boolean contains(@Nullable long[] aValues, long aSearchValue) {
        return ArrayHelper.getFirstIndex(aValues, aSearchValue) >= 0;
    }

    public static boolean contains(@Nullable short[] aValues, short aSearchValue) {
        return ArrayHelper.getFirstIndex(aValues, aSearchValue) >= 0;
    }

    public static boolean getFirst(@Nullable boolean[] aArray, boolean aDefaultValue) {
        return ArrayHelper.isEmpty(aArray) ? aDefaultValue : aArray[0];
    }

    public static byte getFirst(@Nullable byte[] aArray, byte aDefaultValue) {
        return ArrayHelper.isEmpty(aArray) ? aDefaultValue : aArray[0];
    }

    public static char getFirst(@Nullable char[] aArray, char aDefaultValue) {
        return ArrayHelper.isEmpty(aArray) ? aDefaultValue : aArray[0];
    }

    public static double getFirst(@Nullable double[] aArray, double aDefaultValue) {
        return ArrayHelper.isEmpty(aArray) ? aDefaultValue : aArray[0];
    }

    public static float getFirst(@Nullable float[] aArray, float aDefaultValue) {
        return ArrayHelper.isEmpty(aArray) ? aDefaultValue : aArray[0];
    }

    public static int getFirst(@Nullable int[] aArray, int aDefaultValue) {
        return ArrayHelper.isEmpty(aArray) ? aDefaultValue : aArray[0];
    }

    public static long getFirst(@Nullable long[] aArray, long aDefaultValue) {
        return ArrayHelper.isEmpty(aArray) ? aDefaultValue : aArray[0];
    }

    public static short getFirst(@Nullable short[] aArray, short aDefaultValue) {
        return ArrayHelper.isEmpty(aArray) ? aDefaultValue : aArray[0];
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirst(ELEMENTTYPE ... aArray) {
        return ArrayHelper.getFirst(aArray, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirst(@Nullable ELEMENTTYPE[] aArray, @Nullable ELEMENTTYPE aDefaultValue) {
        return ArrayHelper.isEmpty(aArray) ? aDefaultValue : aArray[0];
    }

    public static boolean getLast(@Nullable boolean[] aArray, boolean aDefaultValue) {
        int nSize = ArrayHelper.getSize(aArray);
        return nSize == 0 ? aDefaultValue : aArray[nSize - 1];
    }

    public static byte getLast(@Nullable byte[] aArray, byte aDefaultValue) {
        int nSize = ArrayHelper.getSize(aArray);
        return nSize == 0 ? aDefaultValue : aArray[nSize - 1];
    }

    public static char getLast(@Nullable char[] aArray, char aDefaultValue) {
        int nSize = ArrayHelper.getSize(aArray);
        return nSize == 0 ? aDefaultValue : aArray[nSize - 1];
    }

    public static double getLast(@Nullable double[] aArray, double aDefaultValue) {
        int nSize = ArrayHelper.getSize(aArray);
        return nSize == 0 ? aDefaultValue : aArray[nSize - 1];
    }

    public static float getLast(@Nullable float[] aArray, float aDefaultValue) {
        int nSize = ArrayHelper.getSize(aArray);
        return nSize == 0 ? aDefaultValue : aArray[nSize - 1];
    }

    public static int getLast(@Nullable int[] aArray, int aDefaultValue) {
        int nSize = ArrayHelper.getSize(aArray);
        return nSize == 0 ? aDefaultValue : aArray[nSize - 1];
    }

    public static long getLast(@Nullable long[] aArray, long aDefaultValue) {
        int nSize = ArrayHelper.getSize(aArray);
        return nSize == 0 ? aDefaultValue : aArray[nSize - 1];
    }

    public static short getLast(@Nullable short[] aArray, short aDefaultValue) {
        int nSize = ArrayHelper.getSize(aArray);
        return nSize == 0 ? aDefaultValue : aArray[nSize - 1];
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLast(ELEMENTTYPE ... aArray) {
        return ArrayHelper.getLast(aArray, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLast(@Nullable ELEMENTTYPE[] aArray, @Nullable ELEMENTTYPE aDefaultValue) {
        int nSize = ArrayHelper.getSize(aArray);
        return nSize == 0 ? aDefaultValue : aArray[nSize - 1];
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getCopy(boolean ... aArray) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, aArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getCopy(@Nullable boolean[] aArray, @Nonnegative int nLength) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, Math.min(aArray.length, nLength));
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getCopy(@Nullable boolean[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            return null;
        }
        boolean[] ret = new boolean[nLength];
        System.arraycopy(aArray, nStartIndex, ret, 0, nLength);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getCopy(byte ... aArray) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, aArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getCopy(@Nullable byte[] aArray, @Nonnegative int nLength) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, Math.min(aArray.length, nLength));
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getCopy(@Nullable byte[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            return null;
        }
        byte[] ret = new byte[nLength];
        System.arraycopy(aArray, nStartIndex, ret, 0, nLength);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getCopy(char ... aArray) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, aArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getCopy(@Nullable char[] aArray, @Nonnegative int nLength) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, Math.min(aArray.length, nLength));
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getCopy(@Nullable char[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            return null;
        }
        char[] ret = new char[nLength];
        System.arraycopy(aArray, nStartIndex, ret, 0, nLength);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getCopy(double ... aArray) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, aArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getCopy(@Nullable double[] aArray, @Nonnegative int nLength) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, Math.min(aArray.length, nLength));
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getCopy(@Nullable double[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            return null;
        }
        double[] ret = new double[nLength];
        System.arraycopy(aArray, nStartIndex, ret, 0, nLength);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getCopy(float ... aArray) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, aArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getCopy(@Nullable float[] aArray, @Nonnegative int nLength) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, Math.min(aArray.length, nLength));
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getCopy(@Nullable float[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            return null;
        }
        float[] ret = new float[nLength];
        System.arraycopy(aArray, nStartIndex, ret, 0, nLength);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getCopy(int ... aArray) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, aArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getCopy(@Nullable int[] aArray, @Nonnegative int nLength) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, Math.min(aArray.length, nLength));
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getCopy(@Nullable int[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            return null;
        }
        int[] ret = new int[nLength];
        System.arraycopy(aArray, nStartIndex, ret, 0, nLength);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getCopy(long ... aArray) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, aArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getCopy(@Nullable long[] aArray, @Nonnegative int nLength) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, Math.min(aArray.length, nLength));
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getCopy(@Nullable long[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            return null;
        }
        long[] ret = new long[nLength];
        System.arraycopy(aArray, nStartIndex, ret, 0, nLength);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getCopy(short ... aArray) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, aArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getCopy(@Nullable short[] aArray, @Nonnegative int nLength) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, Math.min(aArray.length, nLength));
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getCopy(@Nullable short[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            return null;
        }
        short[] ret = new short[nLength];
        System.arraycopy(aArray, nStartIndex, ret, 0, nLength);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getCopy(ELEMENTTYPE ... aArray) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, aArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getCopy(@Nullable ELEMENTTYPE[] aArray, @Nonnegative int nLength) {
        return aArray == null ? null : ArrayHelper.getCopy(aArray, 0, Math.min(aArray.length, nLength));
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getCopy(@Nullable ELEMENTTYPE[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            return null;
        }
        ELEMENTTYPE[] ret = ArrayHelper.newArraySameType(aArray, nLength);
        System.arraycopy(aArray, nStartIndex, ret, 0, nLength);
        return ret;
    }

    @Deprecated
    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getConcatenated(@Nullable ELEMENTTYPE[] aHeadArray, @Nullable ELEMENTTYPE[] aTailArray, Class<ELEMENTTYPE> aClass) {
        return ArrayHelper.getConcatenated(aHeadArray, aTailArray);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getConcatenated(@Nullable ELEMENTTYPE[] aHeadArray, @Nullable ELEMENTTYPE[] aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        ELEMENTTYPE[] ret = ArrayHelper.newArraySameType(aHeadArray, aHeadArray.length + aTailArray.length);
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getConcatenated(@Nullable ELEMENTTYPE aHead, @Nullable ELEMENTTYPE[] aTailArray, @Nonnull Class<ELEMENTTYPE> aClass) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.newArraySingleElement(aHead, aClass);
        }
        ELEMENTTYPE[] ret = ArrayHelper.newArray(aClass, 1 + aTailArray.length);
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getConcatenated(@Nullable ELEMENTTYPE[] aHeadArray, @Nullable ELEMENTTYPE aTail, @Nonnull Class<ELEMENTTYPE> aClass) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.newArraySingleElement(aTail, aClass);
        }
        ELEMENTTYPE[] ret = ArrayHelper.newArray(aClass, aHeadArray.length + 1);
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static boolean[] getConcatenated(@Nullable boolean[] aHeadArray, boolean ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        boolean[] ret = new boolean[aHeadArray.length + aTailArray.length];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static boolean[] getConcatenated(boolean aHead, boolean ... aTailArray) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return new boolean[]{aHead};
        }
        boolean[] ret = new boolean[1 + aTailArray.length];
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static boolean[] getConcatenated(@Nullable boolean[] aHeadArray, boolean aTail) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return new boolean[]{aTail};
        }
        boolean[] ret = new boolean[aHeadArray.length + 1];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getConcatenated(@Nullable byte[] aHeadArray, byte ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        byte[] ret = new byte[aHeadArray.length + aTailArray.length];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getConcatenated(byte aHead, byte ... aTailArray) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return new byte[]{aHead};
        }
        byte[] ret = new byte[1 + aTailArray.length];
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getConcatenated(@Nullable byte[] aHeadArray, byte aTail) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return new byte[]{aTail};
        }
        byte[] ret = new byte[aHeadArray.length + 1];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[] getConcatenated(@Nullable char[] aHeadArray, char ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        char[] ret = new char[aHeadArray.length + aTailArray.length];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[][] getConcatenated(@Nullable char[][] aHeadArray, char[] ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return (char[][])ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return (char[][])ArrayHelper.getCopy(aHeadArray);
        }
        char[][] ret = new char[aHeadArray.length + aTailArray.length][];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[] getConcatenated(char aHead, char ... aTailArray) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return new char[]{aHead};
        }
        char[] ret = new char[1 + aTailArray.length];
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[] getConcatenated(@Nullable char[] aHeadArray, char aTail) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return new char[]{aTail};
        }
        char[] ret = new char[aHeadArray.length + 1];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static double[] getConcatenated(@Nullable double[] aHeadArray, double ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        double[] ret = new double[aHeadArray.length + aTailArray.length];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static double[] getConcatenated(double aHead, double ... aTailArray) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return new double[]{aHead};
        }
        double[] ret = new double[1 + aTailArray.length];
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static double[] getConcatenated(@Nullable double[] aHeadArray, double aTail) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return new double[]{aTail};
        }
        double[] ret = new double[aHeadArray.length + 1];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static float[] getConcatenated(@Nullable float[] aHeadArray, float ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        float[] ret = new float[aHeadArray.length + aTailArray.length];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static float[] getConcatenated(float aHead, float ... aTailArray) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return new float[]{aHead};
        }
        float[] ret = new float[1 + aTailArray.length];
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static float[] getConcatenated(@Nullable float[] aHeadArray, float aTail) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return new float[]{aTail};
        }
        float[] ret = new float[aHeadArray.length + 1];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static int[] getConcatenated(@Nullable int[] aHeadArray, int ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        int[] ret = new int[aHeadArray.length + aTailArray.length];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static int[] getConcatenated(int aHead, int ... aTailArray) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return new int[]{aHead};
        }
        int[] ret = new int[1 + aTailArray.length];
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static int[] getConcatenated(@Nullable int[] aHeadArray, int aTail) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return new int[]{aTail};
        }
        int[] ret = new int[aHeadArray.length + 1];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static long[] getConcatenated(@Nullable long[] aHeadArray, long ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        long[] ret = new long[aHeadArray.length + aTailArray.length];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static long[] getConcatenated(long aHead, long ... aTailArray) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return new long[]{aHead};
        }
        long[] ret = new long[1 + aTailArray.length];
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static long[] getConcatenated(@Nullable long[] aHeadArray, long aTail) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return new long[]{aTail};
        }
        long[] ret = new long[aHeadArray.length + 1];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static short[] getConcatenated(@Nullable short[] aHeadArray, short ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        short[] ret = new short[aHeadArray.length + aTailArray.length];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static short[] getConcatenated(short aHead, short ... aTailArray) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return new short[]{aHead};
        }
        short[] ret = new short[1 + aTailArray.length];
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static short[] getConcatenated(@Nullable short[] aHeadArray, short aTail) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return new short[]{aTail};
        }
        short[] ret = new short[aHeadArray.length + 1];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getConcatenated(@Nullable String[] aHeadArray, String ... aTailArray) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return ArrayHelper.getCopy(aTailArray);
        }
        if (ArrayHelper.isEmpty(aTailArray)) {
            return ArrayHelper.getCopy(aHeadArray);
        }
        String[] ret = new String[aHeadArray.length + aTailArray.length];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        System.arraycopy(aTailArray, 0, ret, aHeadArray.length, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getConcatenated(String aHead, String ... aTailArray) {
        if (ArrayHelper.isEmpty(aTailArray)) {
            return new String[]{aHead};
        }
        String[] ret = new String[1 + aTailArray.length];
        ret[0] = aHead;
        System.arraycopy(aTailArray, 0, ret, 1, aTailArray.length);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getConcatenated(@Nullable String[] aHeadArray, String aTail) {
        if (ArrayHelper.isEmpty(aHeadArray)) {
            return new String[]{aTail};
        }
        String[] ret = new String[aHeadArray.length + 1];
        System.arraycopy(aHeadArray, 0, ret, 0, aHeadArray.length);
        ret[aHeadArray.length] = aTail;
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExceptFirst(ELEMENTTYPE ... aArray) {
        return ArrayHelper.getAllExceptFirst(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExceptFirst(@Nullable ELEMENTTYPE[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, nElementsToSkip, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExcept(@Nullable ELEMENTTYPE[] aArray, ELEMENTTYPE ... aElementsToRemove) {
        if (ArrayHelper.isEmpty(aArray) || ArrayHelper.isEmpty(aElementsToRemove)) {
            return aArray;
        }
        ELEMENTTYPE[] tmp = ArrayHelper.getCopy(aArray);
        int nDst = 0;
        for (int nSrc = 0; nSrc < tmp.length; ++nSrc) {
            if (ArrayHelper.contains(aElementsToRemove, tmp[nSrc])) continue;
            tmp[nDst++] = tmp[nSrc];
        }
        return ArrayHelper.getCopy(tmp, 0, nDst);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExcept(@Nullable boolean[] aArray, boolean ... aElementsToRemove) {
        if (ArrayHelper.isEmpty(aArray) || ArrayHelper.isEmpty(aElementsToRemove)) {
            return aArray;
        }
        boolean[] tmp = ArrayHelper.getCopy(aArray);
        int nDst = 0;
        for (int nSrc = 0; nSrc < tmp.length; ++nSrc) {
            if (ArrayHelper.contains(aElementsToRemove, tmp[nSrc])) continue;
            tmp[nDst++] = tmp[nSrc];
        }
        return ArrayHelper.getCopy(tmp, 0, nDst);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExcept(@Nullable byte[] aArray, byte ... aElementsToRemove) {
        if (ArrayHelper.isEmpty(aArray) || ArrayHelper.isEmpty(aElementsToRemove)) {
            return aArray;
        }
        byte[] tmp = ArrayHelper.getCopy(aArray);
        int nDst = 0;
        for (int nSrc = 0; nSrc < tmp.length; ++nSrc) {
            if (ArrayHelper.contains(aElementsToRemove, tmp[nSrc])) continue;
            tmp[nDst++] = tmp[nSrc];
        }
        return ArrayHelper.getCopy(tmp, 0, nDst);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExcept(@Nullable char[] aArray, char ... aElementsToRemove) {
        if (ArrayHelper.isEmpty(aArray) || ArrayHelper.isEmpty(aElementsToRemove)) {
            return aArray;
        }
        char[] tmp = ArrayHelper.getCopy(aArray);
        int nDst = 0;
        for (int nSrc = 0; nSrc < tmp.length; ++nSrc) {
            if (ArrayHelper.contains(aElementsToRemove, tmp[nSrc])) continue;
            tmp[nDst++] = tmp[nSrc];
        }
        return ArrayHelper.getCopy(tmp, 0, nDst);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExcept(@Nullable double[] aArray, double ... aElementsToRemove) {
        if (ArrayHelper.isEmpty(aArray) || ArrayHelper.isEmpty(aElementsToRemove)) {
            return aArray;
        }
        double[] tmp = ArrayHelper.getCopy(aArray);
        int nDst = 0;
        for (int nSrc = 0; nSrc < tmp.length; ++nSrc) {
            if (ArrayHelper.contains(aElementsToRemove, tmp[nSrc])) continue;
            tmp[nDst++] = tmp[nSrc];
        }
        return ArrayHelper.getCopy(tmp, 0, nDst);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExcept(@Nullable float[] aArray, float ... aElementsToRemove) {
        if (ArrayHelper.isEmpty(aArray) || ArrayHelper.isEmpty(aElementsToRemove)) {
            return aArray;
        }
        float[] tmp = ArrayHelper.getCopy(aArray);
        int nDst = 0;
        for (int nSrc = 0; nSrc < tmp.length; ++nSrc) {
            if (ArrayHelper.contains(aElementsToRemove, tmp[nSrc])) continue;
            tmp[nDst++] = tmp[nSrc];
        }
        return ArrayHelper.getCopy(tmp, 0, nDst);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExcept(@Nullable int[] aArray, int ... aElementsToRemove) {
        if (ArrayHelper.isEmpty(aArray) || ArrayHelper.isEmpty(aElementsToRemove)) {
            return aArray;
        }
        int[] tmp = ArrayHelper.getCopy(aArray);
        int nDst = 0;
        for (int nSrc = 0; nSrc < tmp.length; ++nSrc) {
            if (ArrayHelper.contains(aElementsToRemove, tmp[nSrc])) continue;
            tmp[nDst++] = tmp[nSrc];
        }
        return ArrayHelper.getCopy(tmp, 0, nDst);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExcept(@Nullable long[] aArray, long ... aElementsToRemove) {
        if (ArrayHelper.isEmpty(aArray) || ArrayHelper.isEmpty(aElementsToRemove)) {
            return aArray;
        }
        long[] tmp = ArrayHelper.getCopy(aArray);
        int nDst = 0;
        for (int nSrc = 0; nSrc < tmp.length; ++nSrc) {
            if (ArrayHelper.contains(aElementsToRemove, tmp[nSrc])) continue;
            tmp[nDst++] = tmp[nSrc];
        }
        return ArrayHelper.getCopy(tmp, 0, nDst);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExcept(@Nullable short[] aArray, short ... aElementsToRemove) {
        if (ArrayHelper.isEmpty(aArray) || ArrayHelper.isEmpty(aElementsToRemove)) {
            return aArray;
        }
        short[] tmp = ArrayHelper.getCopy(aArray);
        int nDst = 0;
        for (int nSrc = 0; nSrc < tmp.length; ++nSrc) {
            if (ArrayHelper.contains(aElementsToRemove, tmp[nSrc])) continue;
            tmp[nDst++] = tmp[nSrc];
        }
        return ArrayHelper.getCopy(tmp, 0, nDst);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExceptFirst(boolean ... aArray) {
        return ArrayHelper.getAllExceptFirst(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExceptFirst(@Nullable boolean[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, nElementsToSkip, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExceptFirst(byte ... aArray) {
        return ArrayHelper.getAllExceptFirst(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExceptFirst(@Nullable byte[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, nElementsToSkip, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExceptFirst(char ... aArray) {
        return ArrayHelper.getAllExceptFirst(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExceptFirst(@Nullable char[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, nElementsToSkip, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExceptFirst(double ... aArray) {
        return ArrayHelper.getAllExceptFirst(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExceptFirst(@Nullable double[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, nElementsToSkip, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExceptFirst(float ... aArray) {
        return ArrayHelper.getAllExceptFirst(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExceptFirst(@Nullable float[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, nElementsToSkip, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExceptFirst(int ... aArray) {
        return ArrayHelper.getAllExceptFirst(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExceptFirst(@Nullable int[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, nElementsToSkip, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExceptFirst(long ... aArray) {
        return ArrayHelper.getAllExceptFirst(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExceptFirst(@Nullable long[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, nElementsToSkip, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExceptFirst(short ... aArray) {
        return ArrayHelper.getAllExceptFirst(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExceptFirst(@Nullable short[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, nElementsToSkip, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExceptLast(ELEMENTTYPE ... aArray) {
        return ArrayHelper.getAllExceptLast(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExceptLast(@Nullable ELEMENTTYPE[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, 0, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExceptLast(boolean ... aArray) {
        return ArrayHelper.getAllExceptLast(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExceptLast(@Nullable boolean[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, 0, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExceptLast(byte ... aArray) {
        return ArrayHelper.getAllExceptLast(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExceptLast(@Nullable byte[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, 0, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExceptLast(char ... aArray) {
        return ArrayHelper.getAllExceptLast(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExceptLast(@Nullable char[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, 0, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExceptLast(double ... aArray) {
        return ArrayHelper.getAllExceptLast(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExceptLast(@Nullable double[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, 0, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExceptLast(float ... aArray) {
        return ArrayHelper.getAllExceptLast(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExceptLast(@Nullable float[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, 0, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExceptLast(int ... aArray) {
        return ArrayHelper.getAllExceptLast(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExceptLast(@Nullable int[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, 0, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExceptLast(long ... aArray) {
        return ArrayHelper.getAllExceptLast(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExceptLast(@Nullable long[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, 0, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExceptLast(short ... aArray) {
        return ArrayHelper.getAllExceptLast(aArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExceptLast(@Nullable short[] aArray, @Nonnegative int nElementsToSkip) {
        if (nElementsToSkip < 0) {
            throw new IllegalArgumentException("The number of elements to skip is invalid: " + nElementsToSkip);
        }
        if (nElementsToSkip == 0) {
            return aArray;
        }
        if (aArray == null || nElementsToSkip >= aArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(aArray, 0, aArray.length - nElementsToSkip);
    }

    @Nullable
    @ReturnsMutableObject(reason="use getCopy otherwise")
    public static boolean[] newBooleanArray(boolean ... aArray) {
        return aArray;
    }

    @Nullable
    @ReturnsMutableObject(reason="use getCopy otherwise")
    public static byte[] newByteArray(byte ... aArray) {
        return aArray;
    }

    @Nullable
    @ReturnsMutableObject(reason="use getCopy otherwise")
    public static char[] newCharArray(char ... aArray) {
        return aArray;
    }

    @Nullable
    @ReturnsMutableObject(reason="use getCopy otherwise")
    public static double[] newDoubleArray(double ... aArray) {
        return aArray;
    }

    @Nullable
    @ReturnsMutableObject(reason="use getCopy otherwise")
    public static float[] newFloatArray(float ... aArray) {
        return aArray;
    }

    @Nullable
    @ReturnsMutableObject(reason="use getCopy otherwise")
    public static int[] newIntArray(int ... aArray) {
        return aArray;
    }

    @Nullable
    @ReturnsMutableObject(reason="use getCopy otherwise")
    public static long[] newLongArray(long ... aArray) {
        return aArray;
    }

    @Nullable
    @ReturnsMutableObject(reason="use getCopy otherwise")
    public static short[] newShortArray(short ... aArray) {
        return aArray;
    }

    @Nonnull
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArray(@Nonnull Class<? extends ELEMENTTYPE> aClass, @Nonnegative int nSize) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        if (aClass.isPrimitive()) {
            throw new IllegalArgumentException("Argument cannot be primitive: " + aClass);
        }
        if (nSize < 0) {
            throw new IllegalArgumentException("Array size must be >= 0: " + nSize);
        }
        Object aArray = Array.newInstance(aClass, nSize);
        return (Object[])GenericReflection.uncheckedCast(aArray);
    }

    @Nonnull
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArraySameType(@Nonnull ELEMENTTYPE[] aArray, @Nonnegative int nSize) {
        return ArrayHelper.newArray(ArrayHelper.getComponentType(aArray), nSize);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArray(@Nullable Collection<? extends ELEMENTTYPE> aCollection, @Nonnull Class<ELEMENTTYPE> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        if (ContainerHelper.isEmpty(aCollection)) {
            return ArrayHelper.newArray(aClass, 0);
        }
        ELEMENTTYPE[] ret = ArrayHelper.newArray(aClass, aCollection.size());
        return aCollection.toArray(ret);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArraySingleElement(@Nullable ELEMENTTYPE aElement, @Nonnull Class<ELEMENTTYPE> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        ELEMENTTYPE[] ret = ArrayHelper.newArray(aClass, 1);
        ret[0] = aElement;
        return ret;
    }

    @Nonnull
    @ReturnsMutableObject(reason="use getCopy otherwise")
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArray(ELEMENTTYPE ... aArray) {
        if (aArray == null) {
            throw new NullPointerException("array");
        }
        return aArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArray(@Nonnegative int nArraySize, @Nonnull ELEMENTTYPE aValue, @Nonnull Class<ELEMENTTYPE> aClass) {
        if (nArraySize < 0) {
            throw new IllegalArgumentException("Passed array size must be >= 0");
        }
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        Object[] ret = ArrayHelper.newArray(aClass, nArraySize);
        Arrays.fill(ret, aValue);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static Object[] getAsObjectArray(@Nullable Collection<?> aCollection) {
        if (ContainerHelper.isEmpty(aCollection)) {
            return null;
        }
        Object[] ret = new Object[aCollection.size()];
        return aCollection.toArray(ret);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getSafeElement(@Nullable ELEMENTTYPE[] aItems, int nIndex) {
        return ArrayHelper.getSafeElement(aItems, nIndex, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getSafeElement(@Nullable ELEMENTTYPE[] aItems, int nIndex, @Nullable ELEMENTTYPE aDefault) {
        return aItems != null && nIndex >= 0 && nIndex < aItems.length ? aItems[nIndex] : aDefault;
    }

    public static boolean isArrayEquals(@Nullable Object aHeadArray, @Nullable Object aTailArray) {
        if (aHeadArray == aTailArray) {
            return true;
        }
        if (aHeadArray == null || aTailArray == null) {
            return false;
        }
        if (!ArrayHelper.isArray(aHeadArray) || !ArrayHelper.isArray(aTailArray)) {
            return false;
        }
        if (!aHeadArray.getClass().getComponentType().equals(aTailArray.getClass().getComponentType())) {
            return false;
        }
        int nLength = Array.getLength(aHeadArray);
        if (nLength != Array.getLength(aTailArray)) {
            return false;
        }
        for (int i = 0; i < nLength; ++i) {
            Object aItem1 = Array.get(aHeadArray, i);
            Object aItem2 = Array.get(aTailArray, i);
            if (!(ArrayHelper.isArray(aItem1) && ArrayHelper.isArray(aItem2) ? !ArrayHelper.isArrayEquals(aItem1, aItem2) : !EqualsUtils.equals(aItem1, aItem2))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsAnyNullElement(@Nullable T[] aArray) {
        if (aArray != null) {
            for (T aObj : aArray) {
                if (aObj != null) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean containsOnlyNullElements(@Nullable T[] aArray) {
        if (ArrayHelper.isEmpty(aArray)) {
            return false;
        }
        for (T aObj : aArray) {
            if (aObj == null) continue;
            return false;
        }
        return true;
    }
}

