/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.IIntIDFactory;
import com.phloc.commons.string.ToStringGenerator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MemoryIntIDFactory
implements IIntIDFactory {
    @Nonnegative
    public static final int DEFAULT_START_ID = 10000;
    @Nonnegative
    private final AtomicInteger m_aID;

    public MemoryIntIDFactory() {
        this(10000);
    }

    public MemoryIntIDFactory(@Nonnegative int nStartID) {
        if (nStartID < 0) {
            throw new IllegalArgumentException("Passed start ID is invalid: " + nStartID);
        }
        this.m_aID = new AtomicInteger(nStartID);
    }

    @Override
    @Nonnegative
    public int getNewID() {
        return this.m_aID.getAndIncrement();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoryIntIDFactory)) {
            return false;
        }
        MemoryIntIDFactory rhs = (MemoryIntIDFactory)o;
        return this.m_aID.get() == rhs.m_aID.get();
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aID.get()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_aID).toString();
    }
}

