/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.iterate;

import com.phloc.commons.combine.CombinatorStringWithSeparatorIgnoreNull;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.file.filter.FileFilterFileFromFilenameFilter;
import com.phloc.commons.tree.withid.folder.DefaultFolderTree;
import com.phloc.commons.tree.withid.folder.DefaultFolderTreeItem;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemFolderTree
extends DefaultFolderTree<String, File, List<File>> {
    private static void _iterate(@Nonnull DefaultFolderTreeItem<String, File, List<File>> aTreeItem, @Nonnull File aDir, @Nullable FileFilter aDirFilter, @Nullable FileFilter aFileFilter) {
        if (aDir != null) {
            for (File aChild : FileUtils.getDirectoryContent(aDir)) {
                if (aChild.isFile()) {
                    if (aFileFilter != null && !aFileFilter.accept(aChild)) continue;
                    ((List)aTreeItem.getData()).add(aChild);
                    continue;
                }
                if (!aChild.isDirectory() || FilenameHelper.isSystemInternalDirectory(aChild) || aDirFilter != null && !aDirFilter.accept(aChild)) continue;
                DefaultFolderTreeItem aChildItem = (DefaultFolderTreeItem)aTreeItem.createChildItem(aChild.getName(), (File)((Object)new ArrayList()));
                FileSystemFolderTree._iterate(aChildItem, aChild, aDirFilter, aFileFilter);
            }
        }
    }

    public FileSystemFolderTree(@Nonnull String sStartDir) {
        this(new File(sStartDir));
    }

    public FileSystemFolderTree(@Nonnull File aStartDir) {
        this(aStartDir, (FileFilter)null, (FileFilter)null);
    }

    public FileSystemFolderTree(@Nonnull String sStartDir, @Nullable FilenameFilter aDirFilter, @Nullable FilenameFilter aFileFilter) {
        this(new File(sStartDir), aDirFilter, aFileFilter);
    }

    public FileSystemFolderTree(@Nonnull String sStartDir, @Nullable FileFilter aDirFilter, @Nullable FileFilter aFileFilter) {
        this(new File(sStartDir), aDirFilter, aFileFilter);
    }

    public FileSystemFolderTree(@Nonnull File aStartDir, @Nullable FilenameFilter aDirFilter, @Nullable FilenameFilter aFileFilter) {
        this(aStartDir, (FileFilter)(aDirFilter == null ? null : new FileFilterFileFromFilenameFilter(aDirFilter)), (FileFilter)(aFileFilter == null ? null : new FileFilterFileFromFilenameFilter(aFileFilter)));
    }

    public FileSystemFolderTree(@Nonnull File aStartDir, @Nullable FileFilter aDirFilter, @Nullable FileFilter aFileFilter) {
        super(new CombinatorStringWithSeparatorIgnoreNull("/"));
        if (aStartDir == null) {
            throw new NullPointerException("startDir");
        }
        if (!aStartDir.isDirectory()) {
            throw new IllegalArgumentException("Start directory is not a directory!");
        }
        DefaultFolderTreeItem aStart = (DefaultFolderTreeItem)((DefaultFolderTreeItem)this.getRootItem()).createChildItem(aStartDir.getName(), new ArrayList());
        FileSystemFolderTree._iterate(aStart, aStartDir, aDirFilter, aFileFilter);
    }
}

