/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jaxb.validation;

import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.jaxb.validation.AbstractValidationEventHandler;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LoggingValidationEventHandler
extends AbstractValidationEventHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingValidationEventHandler.class);
    private static final LoggingValidationEventHandler s_aInstance = new LoggingValidationEventHandler();

    public LoggingValidationEventHandler() {
    }

    public LoggingValidationEventHandler(@Nullable ValidationEventHandler aOrigHandler) {
        super(aOrigHandler);
    }

    @Nonnull
    public static LoggingValidationEventHandler getInstance() {
        return s_aInstance;
    }

    @Override
    protected void onEvent(@Nonnull IResourceError aEvent) {
        String sMsg = "JAXB " + aEvent.getAsString(Locale.US);
        if (aEvent.getErrorLevel().isLessOrEqualSevereThan(EErrorLevel.WARN)) {
            s_aLogger.warn(sMsg, aEvent.getLinkedException());
        } else {
            s_aLogger.error(sMsg, aEvent.getLinkedException());
        }
    }
}

