/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.id.IHasID;
import com.phloc.commons.id.IHasSimpleIntID;
import com.phloc.commons.name.IHasName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EnumHelper {
    private static final EnumHelper s_aInstance = new EnumHelper();

    private EnumHelper() {
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> aClass, @Nullable KEYTYPE aID) {
        return EnumHelper.getFromIDOrDefault(aClass, aID, null);
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> aClass, @Nullable KEYTYPE aID, @Nullable ENUMTYPE aDefault) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        if (aID != null) {
            for (Enum aElement : (Enum[])aClass.getEnumConstants()) {
                if (!((IHasID)((Object)aElement)).getID().equals(aID)) continue;
                return (ENUMTYPE)aElement;
            }
        }
        return aDefault;
    }

    @Nonnull
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> aClass, @Nullable KEYTYPE aID) {
        ENUMTYPE aEnum = EnumHelper.getFromIDOrNull(aClass, aID);
        if (aEnum == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + aID + " within class " + aClass);
        }
        return aEnum;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> aClass, @Nullable String sID) {
        return EnumHelper.getFromIDCaseInsensitiveOrDefault(aClass, sID, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> aClass, @Nullable String sID, @Nullable ENUMTYPE aDefault) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        if (sID != null) {
            for (Enum aElement : (Enum[])aClass.getEnumConstants()) {
                if (!((String)((IHasID)((Object)aElement)).getID()).equalsIgnoreCase(sID)) continue;
                return (ENUMTYPE)aElement;
            }
        }
        return aDefault;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> aClass, @Nullable String sID) {
        ENUMTYPE aEnum = EnumHelper.getFromIDCaseInsensitiveOrNull(aClass, sID);
        if (aEnum == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + sID + " within class " + aClass);
        }
        return aEnum;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> aClass, int nID) {
        return EnumHelper.getFromIDOrDefault(aClass, nID, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> aClass, int nID, @Nullable ENUMTYPE aDefault) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        for (Enum aElement : (Enum[])aClass.getEnumConstants()) {
            if (((IHasSimpleIntID)((Object)aElement)).getID() != nID) continue;
            return (ENUMTYPE)aElement;
        }
        return aDefault;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> aClass, int nID) {
        ENUMTYPE aEnum = EnumHelper.getFromIDOrNull(aClass, nID);
        if (aEnum == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + nID + " within class " + aClass);
        }
        return aEnum;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrNull(@Nonnull Class<ENUMTYPE> aClass, @Nullable String sName) {
        return EnumHelper.getFromNameOrDefault(aClass, sName, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrDefault(@Nonnull Class<ENUMTYPE> aClass, @Nullable String sName, @Nullable ENUMTYPE aDefault) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        if (sName != null) {
            for (Enum aElement : (Enum[])aClass.getEnumConstants()) {
                if (!((IHasName)((Object)aElement)).getName().equals(sName)) continue;
                return (ENUMTYPE)aElement;
            }
        }
        return aDefault;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrThrow(@Nonnull Class<ENUMTYPE> aClass, @Nullable String sName) {
        ENUMTYPE aEnum = EnumHelper.getFromNameOrNull(aClass, sName);
        if (aEnum == null) {
            throw new IllegalArgumentException("Failed to resolve name " + sName + " within class " + aClass);
        }
        return aEnum;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> aClass, @Nullable String sName) {
        return EnumHelper.getFromNameCaseInsensitiveOrDefault(aClass, sName, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> aClass, @Nullable String sName, @Nullable ENUMTYPE aDefault) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        if (sName != null) {
            for (Enum aElement : (Enum[])aClass.getEnumConstants()) {
                if (!((IHasName)((Object)aElement)).getName().equalsIgnoreCase(sName)) continue;
                return (ENUMTYPE)aElement;
            }
        }
        return aDefault;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> aClass, @Nullable String sName) {
        ENUMTYPE aEnum = EnumHelper.getFromNameCaseInsensitiveOrNull(aClass, sName);
        if (aEnum == null) {
            throw new IllegalArgumentException("Failed to resolve name " + sName + " within class " + aClass);
        }
        return aEnum;
    }

    @Nonnull
    public static String getEnumID(@Nonnull Enum<?> aEnum) {
        return aEnum.getClass().getName() + '.' + aEnum.name();
    }
}

