/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.ICloneable;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.microdom.IMicroDataAware;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class MicroDataAware
implements IMicroDataAware,
ICloneable<MicroDataAware> {
    private final StringBuilder m_aData;

    public MicroDataAware(@Nullable CharSequence aText) {
        this.m_aData = StringHelper.hasNoText(aText) ? new StringBuilder() : new StringBuilder(aText);
    }

    @Override
    @Nonnull
    public StringBuilder getData() {
        return this.m_aData;
    }

    @Override
    public void setData(@Nullable CharSequence aData) {
        this.m_aData.setLength(0);
        this.m_aData.append(aData);
    }

    @Override
    public void appendData(@Nullable CharSequence sData) {
        this.m_aData.append(sData);
    }

    @Override
    public void prependData(@Nullable CharSequence sData) {
        this.m_aData.insert(0, sData);
    }

    @Override
    @Nonnull
    public MicroDataAware getClone() {
        return new MicroDataAware(this.m_aData);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicroDataAware)) {
            return false;
        }
        MicroDataAware rhs = (MicroDataAware)o;
        return EqualsUtils.equals(this.m_aData, rhs.m_aData);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aData).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("data", this.m_aData).toString();
    }
}

