/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mime;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.exceptions.InitializationException;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.microdom.reader.XMLMapHandler;
import com.phloc.commons.mime.CMimeType;
import com.phloc.commons.mime.IMimeType;
import com.phloc.commons.mime.MimeType;
import com.phloc.commons.regex.RegExHelper;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MimeTypeDeterminator {
    private static final Map<String, String> s_aFileExtMap = new HashMap<String, String>();
    private static final byte[] MIME_ID_GIF87A = new byte[]{71, 73, 70, 56, 55, 97};
    private static final byte[] MIME_ID_GIF89A = new byte[]{71, 73, 70, 56, 57, 97};
    private static final byte[] MIME_ID_JPG = new byte[]{-1, -40};
    private static final byte[] MIME_ID_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] MIME_ID_TIFF_MOTOROLLA = new byte[]{77, 77};
    private static final byte[] MIME_ID_TIFF_INTEL = new byte[]{73, 73};
    private static final byte[] MIME_ID_PSD = new byte[]{56, 66, 80, 83};
    private static final byte[] MIME_ID_XML = new byte[]{60, 63, 120, 109, 108};
    private static final byte[] MIME_ID_PDF = new byte[]{37, 80, 68, 70};
    private static final MimeTypeDeterminator s_aInstance;

    private MimeTypeDeterminator() {
    }

    private static boolean _match(@Nonnull byte[] aBytes, int nOffset, @Nonnull byte[] aCmpBytes) {
        int nEnd = aCmpBytes.length;
        for (int i = 0; i < nEnd; ++i) {
            if (aCmpBytes[i] == aBytes[nOffset + i]) continue;
            return false;
        }
        return true;
    }

    private static boolean _match(@Nonnull byte[] b, @Nonnull byte[] aCmp) {
        return b.length > aCmp.length && MimeTypeDeterminator._match(b, 0, aCmp);
    }

    @Nonnull
    public static IMimeType getMimeTypeFromString(@Nullable String s, @Nonnull @Nonempty String sCharsetName) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(s == null ? null : CharsetManager.getAsBytes(s, sCharsetName));
    }

    @Nonnull
    public static IMimeType getMimeTypeFromString(@Nullable String s, @Nonnull Charset aCharset) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(s == null ? null : CharsetManager.getAsBytes(s, aCharset));
    }

    @Nonnull
    public static IMimeType getMimeTypeFromBytes(@Nullable byte[] b) {
        if (b != null) {
            if (MimeTypeDeterminator._match(b, MIME_ID_GIF87A) || MimeTypeDeterminator._match(b, MIME_ID_GIF89A)) {
                return CMimeType.IMAGE_GIF;
            }
            if (MimeTypeDeterminator._match(b, MIME_ID_JPG)) {
                return CMimeType.IMAGE_JPG;
            }
            if (MimeTypeDeterminator._match(b, MIME_ID_PNG)) {
                return CMimeType.IMAGE_PNG;
            }
            if (MimeTypeDeterminator._match(b, MIME_ID_TIFF_INTEL) || MimeTypeDeterminator._match(b, MIME_ID_TIFF_MOTOROLLA)) {
                return CMimeType.IMAGE_TIFF;
            }
            if (MimeTypeDeterminator._match(b, MIME_ID_PSD)) {
                return CMimeType.IMAGE_PSD;
            }
            if (MimeTypeDeterminator._match(b, MIME_ID_XML)) {
                return CMimeType.TEXT_XML;
            }
            if (MimeTypeDeterminator._match(b, MIME_ID_PDF)) {
                return CMimeType.APPLICATION_PDF;
            }
        }
        return CMimeType.APPLICATION_OCTET_STREAM;
    }

    @Nullable
    public static String getMimeTypeFromFilename(@Nonnull String sFilename) {
        return MimeTypeDeterminator.getMimeTypeFromExtension(FilenameHelper.getExtension(sFilename));
    }

    @Nullable
    public static IMimeType getMimeTypeObjectFromFilename(@Nonnull String sExtension) {
        return MimeType.parseFromStringWithoutEncoding(MimeTypeDeterminator.getMimeTypeFromFilename(sExtension));
    }

    @Nullable
    public static String getMimeTypeFromExtension(@Nonnull String sExtension) {
        String ret = s_aFileExtMap.get(sExtension);
        if (ret == null) {
            ret = s_aFileExtMap.get(sExtension.toLowerCase());
        }
        return ret;
    }

    @Nullable
    public static IMimeType getMimeTypeObjectFromExtension(@Nonnull String sExtension) {
        return MimeType.parseFromStringWithoutEncoding(MimeTypeDeterminator.getMimeTypeFromExtension(sExtension));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Collection<String> getAllKnownMimeTypes() {
        return ContainerHelper.makeUnmodifiable(s_aFileExtMap.values());
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Map<String, String> getAllKnownMimeTypeFilenameMappings() {
        return ContainerHelper.makeUnmodifiable(s_aFileExtMap);
    }

    static {
        if (XMLMapHandler.readMap(new ClassPathResource("codelists/fileext-mimetype-mapping.xml"), s_aFileExtMap).isFailure()) {
            throw new InitializationException("Failed to init file extension to mimetype mapping file");
        }
        if (GlobalDebug.isDebugMode()) {
            for (Map.Entry<String, String> aEntry : s_aFileExtMap.entrySet()) {
                String sFileExt = aEntry.getKey();
                if (!RegExHelper.stringMatchesPattern("(|[a-zA-Z0-9]+(\\.[a-z0-9]+)*)", sFileExt)) {
                    throw new InitializationException("MIME file extension '" + sFileExt + "' is invalid!");
                }
                if (!aEntry.getValue().contains(" ")) continue;
                throw new InitializationException("MIME type '" + aEntry.getValue() + "' is invalid!");
            }
        }
        s_aInstance = new MimeTypeDeterminator();
    }
}

