/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.state.impl;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IReadonlyWrapper;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.state.ISuccessIndicator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SuccessWithValue<DATATYPE>
implements ISuccessIndicator,
IReadonlyWrapper<DATATYPE> {
    private final ESuccess m_eSuccess;
    private final DATATYPE m_aObj;

    public SuccessWithValue(@Nonnull ISuccessIndicator aSuccessIndicator, @Nullable DATATYPE aObj) {
        if (aSuccessIndicator == null) {
            throw new NullPointerException("successIndicator");
        }
        this.m_eSuccess = ESuccess.valueOf(aSuccessIndicator);
        this.m_aObj = aObj;
    }

    @Override
    public boolean isSuccess() {
        return this.m_eSuccess.isSuccess();
    }

    @Override
    public boolean isFailure() {
        return this.m_eSuccess.isFailure();
    }

    @Override
    @Nullable
    public DATATYPE get() {
        return this.m_aObj;
    }

    @Nullable
    public DATATYPE getIfSuccess(@Nullable DATATYPE aFailureValue) {
        return this.m_eSuccess.isSuccess() ? this.m_aObj : aFailureValue;
    }

    @Nullable
    public DATATYPE getIfSuccessOrNull() {
        return this.getIfSuccess(null);
    }

    @Nullable
    public DATATYPE getIfFailure(@Nullable DATATYPE aSuccessValue) {
        return this.m_eSuccess.isFailure() ? this.m_aObj : aSuccessValue;
    }

    @Nullable
    public DATATYPE getIfFailureOrNull() {
        return this.getIfFailure(null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuccessWithValue)) {
            return false;
        }
        SuccessWithValue rhs = (SuccessWithValue)o;
        return this.m_eSuccess.equals(rhs.m_eSuccess) && EqualsUtils.equals(this.m_aObj, rhs.m_aObj);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eSuccess)).append(this.m_aObj).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("success", this.m_eSuccess).append("obj", this.m_aObj).toString();
    }

    @Nonnull
    public static <DATATYPE> SuccessWithValue<DATATYPE> createSuccess(@Nullable DATATYPE aValue) {
        return new SuccessWithValue<DATATYPE>(ESuccess.SUCCESS, aValue);
    }

    @Nonnull
    public static <DATATYPE> SuccessWithValue<DATATYPE> createFailure(@Nullable DATATYPE aValue) {
        return new SuccessWithValue<DATATYPE>(ESuccess.FAILURE, aValue);
    }
}

