/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.withid.unique;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.withid.BasicTreeWithID;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import com.phloc.commons.tree.withid.unique.ITreeItemWithUniqueIDFactory;
import com.phloc.commons.tree.withid.unique.ITreeWithGlobalUniqueID;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeWithGlobalUniqueID<KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>>
extends BasicTreeWithID<KEYTYPE, VALUETYPE, ITEMTYPE>
implements ITreeWithGlobalUniqueID<KEYTYPE, VALUETYPE, ITEMTYPE> {
    private final ITreeItemWithUniqueIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> m_aFactory;

    public BasicTreeWithGlobalUniqueID(@Nonnull ITreeItemWithUniqueIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> aFactory) {
        super(aFactory);
        this.m_aFactory = aFactory;
    }

    @Nonnull
    protected final ITreeItemWithUniqueIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> getFactory() {
        return this.m_aFactory;
    }

    @Override
    @Nullable
    public final ITEMTYPE getItemWithID(@Nullable KEYTYPE aDataID) {
        return this.m_aFactory.getItemOfDataID(aDataID);
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildWithID(@Nullable ITEMTYPE aCurrentItem, @Nullable KEYTYPE aDataID) {
        Object aItem = aCurrentItem != null ? aCurrentItem : this.getRootItem();
        return aItem.getChildItemOfDataID(aDataID);
    }

    @Override
    @Nonnull
    public final Collection<ITEMTYPE> getAllItems() {
        return this.m_aFactory.getAllItems();
    }

    @Override
    public final boolean isItemSameOrDescendant(@Nullable KEYTYPE aParentItemID, @Nullable KEYTYPE aChildItemID) {
        Object aSearchParent = this.getItemWithID((Object)aParentItemID);
        if (aSearchParent == null) {
            return false;
        }
        Object aChild = this.getItemWithID((Object)aChildItemID);
        if (aChild == null) {
            return false;
        }
        return aChild.isSameOrChildOf(aSearchParent);
    }

    @Override
    public boolean hasChildren(@Nullable ITEMTYPE aItem) {
        return aItem == null ? this.getRootItem().hasChildren() : aItem.hasChildren();
    }

    @Override
    @Nonnegative
    public int getChildCount(@Nullable ITEMTYPE aItem) {
        return aItem == null ? this.getRootItem().getChildCount() : aItem.getChildCount();
    }

    @Override
    @Nullable
    public List<? extends ITEMTYPE> getChildren(@Nullable ITEMTYPE aItem) {
        return aItem == null ? this.getRootItem().getChildren() : aItem.getChildren();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasicTreeWithGlobalUniqueID rhs = (BasicTreeWithGlobalUniqueID)o;
        return this.m_aFactory.equals(rhs.m_aFactory);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("factory", this.m_aFactory).toString();
    }
}

