/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert;

import com.phloc.commons.annotations.NoTranslationRequired;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.text.impl.TextFormatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TypeConverterException
extends RuntimeException {
    private final Class<?> m_aSrcClass;
    private final Class<?> m_aDstClass;
    private final EReason m_eReason;

    public TypeConverterException(@Nonnull Class<?> aDstClass, @Nonnull EReason eReason) {
        super(eReason.getMessage(aDstClass));
        this.m_aSrcClass = null;
        this.m_aDstClass = aDstClass;
        this.m_eReason = eReason;
    }

    public TypeConverterException(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass, @Nonnull EReason eReason) {
        this(aSrcClass, aDstClass, eReason, null);
    }

    public TypeConverterException(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass, @Nonnull EReason eReason, @Nullable Throwable aCause) {
        super(eReason.getMessage(aSrcClass, aDstClass), aCause);
        this.m_aSrcClass = aSrcClass;
        this.m_aDstClass = aDstClass;
        this.m_eReason = eReason;
    }

    @Nullable
    public Class<?> getSrcClass() {
        return this.m_aSrcClass;
    }

    @Nonnull
    public Class<?> getDstClass() {
        return this.m_aDstClass;
    }

    @Nonnull
    public EReason getReason() {
        return this.m_eReason;
    }

    @NoTranslationRequired(value="because whenever an exception is thrown, no locale is present!")
    public static enum EReason {
        CONVERSION_FAILED(2, "Conversion from type {0} to type {1} failed!"),
        NO_CONVERTER_FOUND(2, "No converter found to convert an object of type {0} to type {1}"),
        NULL_SOURCE_NOT_ALLOWED(1, "A null source object cannot be converted to type {0}");

        private final int m_nParamCount;
        private final String m_sMsg;

        private EReason(int nParamCount, String sMsg) {
            this.m_nParamCount = nParamCount;
            this.m_sMsg = sMsg;
        }

        @Nonnull
        @Nonempty
        public String getMessage(@Nonnull Class<?> aDstClass) {
            if (this.m_nParamCount != 1) {
                throw new IllegalStateException("Message does not expect 1 parameter!");
            }
            return TextFormatter.getFormattedText(this.m_sMsg, aDstClass.getName());
        }

        @Nonnull
        @Nonempty
        public String getMessage(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass) {
            if (this.m_nParamCount != 2) {
                throw new IllegalStateException("Message does not expect 2 parameters!");
            }
            return TextFormatter.getFormattedText(this.m_sMsg, aSrcClass.getName(), aDstClass.getName());
        }
    }
}

