/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.XMLHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public final class FilterElementWithNamespace
implements IFilter<Element> {
    private final String m_sNamespaceURI;

    public FilterElementWithNamespace(@Nullable String sNamespaceURI) {
        this.m_sNamespaceURI = sNamespaceURI;
    }

    @Override
    public boolean matchesFilter(@Nonnull Element aElement) {
        return XMLHelper.hasNamespaceURI(aElement, this.m_sNamespaceURI);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterElementWithNamespace)) {
            return false;
        }
        FilterElementWithNamespace rhs = (FilterElementWithNamespace)o;
        return EqualsUtils.equals(this.m_sNamespaceURI, rhs.m_sNamespaceURI);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sNamespaceURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("namespaceURI", this.m_sNamespaceURI).toString();
    }
}

