/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.xpath;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public final class MapBasedXPathVariableResolver
implements XPathVariableResolver {
    private final Map<String, Object> m_aVars;

    public MapBasedXPathVariableResolver(@Nullable Map<String, Object> aVars) {
        this.m_aVars = aVars;
    }

    @Override
    @Nullable
    public Object resolveVariable(@Nonnull QName aVariableName) {
        if (aVariableName == null) {
            throw new NullPointerException("variableName");
        }
        if (this.m_aVars == null) {
            return null;
        }
        String sLocalName = aVariableName.getLocalPart();
        return this.m_aVars.get(sLocalName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapBasedXPathVariableResolver)) {
            return false;
        }
        MapBasedXPathVariableResolver rhs = (MapBasedXPathVariableResolver)o;
        return EqualsUtils.equals(this.m_aVars, rhs.m_aVars);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aVars)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("vars", this.m_aVars).toString();
    }
}

