/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.CSSURI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSImportRule
implements ICSSWriteable {
    private CSSURI m_aLocation;
    private final List<CSSMediaQuery> m_aMediaQueries = new ArrayList<CSSMediaQuery>();

    public CSSImportRule(@Nonnull CSSURI aLocation) {
        this.setLocation(aLocation);
    }

    public void addMediaQuery(@Nonnull @Nonempty CSSMediaQuery aMediaQuery) {
        this.m_aMediaQueries.add(aMediaQuery);
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnull CSSMediaQuery aMediaQuery) {
        return EChange.valueOf((boolean)this.m_aMediaQueries.remove(aMediaQuery));
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnegative int nMediumIndex) {
        if (nMediumIndex < 0 || nMediumIndex >= this.m_aMediaQueries.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.remove(nMediumIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaQuery> getAllMediaQueries() {
        return ContainerHelper.newList(this.m_aMediaQueries);
    }

    @Nonnull
    public CSSURI getLocation() {
        return this.m_aLocation;
    }

    @Nonnull
    public String getLocationString() {
        return this.m_aLocation.getURI();
    }

    public void setLocation(@Nonnull CSSURI aLocation) {
        if (aLocation == null) {
            throw new NullPointerException("location");
        }
        this.m_aLocation = aLocation;
    }

    public void setLocationString(@Nonnull @Nonempty String sLocationURI) {
        this.m_aLocation.setURI(sLocationURI);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        aSB.append("@import ").append(this.m_aLocation.getAsCSSString(aSettings, nIndentLevel));
        if (!this.m_aMediaQueries.isEmpty()) {
            aSB.append(' ');
            boolean bFirst = true;
            for (CSSMediaQuery aMediaQuery : this.m_aMediaQueries) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    aSB.append(bOptimizedOutput ? "," : ", ");
                }
                aSB.append(aMediaQuery.getAsCSSString(aSettings, nIndentLevel));
            }
        }
        return aSB.append(";\n").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSImportRule)) {
            return false;
        }
        CSSImportRule rhs = (CSSImportRule)o;
        return this.m_aLocation.equals(rhs.m_aLocation) && ((Object)this.m_aMediaQueries).equals(rhs.m_aMediaQueries);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLocation).append(this.m_aMediaQueries).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("location", (Object)this.m_aLocation).append("mediaQueries", this.m_aMediaQueries).toString();
    }
}

