/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSDeclarationContainer;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.IHasCSSDeclarations;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSStyleRule
implements ICSSTopLevelRule,
IHasCSSDeclarations {
    private final List<CSSSelector> m_aSelectors = new ArrayList<CSSSelector>();
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();

    public void addSelector(@Nonnull CSSSelector aSelector) {
        if (aSelector == null) {
            throw new NullPointerException("selector");
        }
        this.m_aSelectors.add(aSelector);
    }

    @Nonnull
    public EChange removeSelector(@Nonnull CSSSelector aSelector) {
        return EChange.valueOf((boolean)this.m_aSelectors.remove(aSelector));
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int nSelectorIndex) {
        if (nSelectorIndex < 0 || nSelectorIndex >= this.m_aSelectors.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aSelectors.remove(nSelectorIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSSelector> getAllSelectors() {
        return ContainerHelper.newList(this.m_aSelectors);
    }

    @Override
    public void addDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        this.m_aDeclarations.addDeclaration(aDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return this.m_aDeclarations.removeDeclaration(aDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        return this.m_aDeclarations.removeDeclaration(nDeclarationIndex);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return this.m_aDeclarations.getDeclarationAtIndex(nIndex);
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Nonnull
    public String getSelectorsAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        boolean bFirst = true;
        for (CSSSelector aSelector : this.m_aSelectors) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(bOptimizedOutput ? "," : ",\n");
            }
            aSB.append(aSelector.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (aSettings.isRemoveUnnecessaryCode() && this.getDeclarationCount() == 0) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        aSB.append(this.getSelectorsAsCSSString(aSettings, nIndentLevel));
        aSB.append(this.m_aDeclarations.getAsCSSString(aSettings, nIndentLevel));
        if (!bOptimizedOutput) {
            aSB.append('\n');
        }
        return aSB.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSStyleRule)) {
            return false;
        }
        CSSStyleRule rhs = (CSSStyleRule)o;
        return ((Object)this.m_aSelectors).equals(rhs.m_aSelectors) && this.m_aDeclarations.equals(rhs.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aSelectors).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("selectors", this.m_aSelectors).append("declarations", (Object)this.m_aDeclarations).toString();
    }
}

