/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.AbstractCSSProperty;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.utils.CSSNumberHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSPropertyNumbers
extends AbstractCSSProperty {
    private final boolean m_bWithPercentage;
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyNumbers(@Nonnull ECSSProperty eProp, boolean bWithPercentage, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers) {
        super(eProp);
        if (nMinNumbers < 0) {
            throw new IllegalArgumentException("minNumbers: " + nMinNumbers);
        }
        if (nMaxNumbers < 0 || nMaxNumbers < nMinNumbers) {
            throw new IllegalArgumentException("maxNumbers: " + nMaxNumbers);
        }
        this.m_bWithPercentage = bWithPercentage;
        this.m_nMinNumbers = nMinNumbers;
        this.m_nMaxNumbers = nMaxNumbers;
    }

    @Override
    public boolean isValidValue(@Nullable String sValue) {
        if (sValue == null) {
            return false;
        }
        String[] aParts = RegExHelper.getSplitToArray((CharSequence)sValue.trim(), (String)"\\s+");
        if (aParts.length < this.m_nMinNumbers || aParts.length > this.m_nMaxNumbers) {
            return false;
        }
        for (int i = 0; i < aParts.length; ++i) {
            if (CSSNumberHelper.isNumberWithUnitValue(aParts[i].trim(), this.m_bWithPercentage)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyNumbers getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyNumbers(eProp, this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).toString();
    }
}

