/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ImageTask
extends Task {
    private String outputFile;
    private ArrayList fileSetList = new ArrayList();
    private PrintStream outputFileStream;

    public void setOutputFile(String string) {
        this.outputFile = string.replace("/", File.separator);
    }

    public void addFileset(FileSet fileSet) {
        this.fileSetList.add(fileSet);
    }

    protected void validate() {
        if (this.outputFile == null) {
            throw new BuildException("file not set");
        }
        if (this.fileSetList.size() < 1) {
            throw new BuildException("fileset not set");
        }
    }

    protected void openOutputFile() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
        this.outputFileStream = new PrintStream((OutputStream)fileOutputStream, true, "UTF-8");
        this.outputFileStream.println("<images>");
    }

    protected void writeImgToOutputFile(String string, Dimension dimension) {
        String string2 = "<image url=\"" + string.replace("\\", "/") + "\"><height>" + dimension.height + "</height><width>" + dimension.width + "</width></image>";
        this.outputFileStream.println(string2);
    }

    protected void closeOutputFile() {
        this.outputFileStream.println("</images>");
        this.outputFileStream.close();
    }

    public void execute() {
        this.validate();
        try {
            this.openOutputFile();
            for (FileSet fileSet : this.fileSetList) {
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    Dimension dimension = this.getImageDim(directoryScanner.getBasedir() + File.separator + string);
                    if (dimension == null) continue;
                    this.writeImgToOutputFile(string, dimension);
                }
            }
            this.closeOutputFile();
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getImageDim(String string) {
        Dimension dimension = null;
        String string2 = this.getFileSuffix(string);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string2);
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            try {
                FileImageInputStream fileImageInputStream = new FileImageInputStream(new File(string));
                imageReader.setInput(fileImageInputStream);
                int n = imageReader.getWidth(imageReader.getMinIndex());
                int n2 = imageReader.getHeight(imageReader.getMinIndex());
                dimension = new Dimension(n, n2);
            }
            catch (IOException iOException) {
                this.log(string + ": " + iOException.getMessage());
            }
            finally {
                imageReader.dispose();
            }
        }
        return dimension;
    }

    private String getFileSuffix(String string) {
        String string2 = null;
        if (string != null) {
            string2 = "";
            if (string.lastIndexOf(46) != -1 && (string2 = string.substring(string.lastIndexOf(46))).startsWith(".")) {
                string2 = string2.substring(1);
            }
        }
        return string2;
    }
}

